/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.client;

import com.github.ipixeli.gender.client.AccessorMC;
import com.github.ipixeli.gender.client.GenderClient;
import com.github.ipixeli.gender.client.Renders;
import com.github.ipixeli.gender.client.gui.ScreenProfile;
import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.Config;
import com.github.ipixeli.gender.core.client.Logic;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="gender", value={Side.CLIENT})
public final class ClientEvents {
    public static boolean needSendPacket = false;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onEvent(InputEvent.KeyInputEvent event) {
        if (needSendPacket) {
            Gender.client().onLogin();
            needSendPacket = false;
        }
        if (AccessorMC.instance().mc().field_71462_r == null && GenderClient.key.func_151468_f()) {
            AccessorMC.instance().mc().func_147108_a((GuiScreen)new ScreenProfile());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onEvent(WorldEvent.Load e) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().func_147114_u() != null) {
            Gender.client().onLogin();
            needSendPacket = false;
        } else {
            needSendPacket = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onEvent(WorldEvent.Unload e) {
        Gender.client().onLogout();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(PlayerEvent.NameFormat e) {
        if (e.getEntityPlayer() == null) {
            return;
        }
        EntityPlayer p = (EntityPlayer)e.getEntity();
        String n = AccessorMC.instance().getName(p);
        String u = AccessorMC.instance().getUuid(p);
        boolean isSelf = AccessorMC.instance().isSelf(p);
        boolean isGuiRender = Renders.isGuiRender();
        String label = Renders.label(n, u, isSelf, isGuiRender, e.getDisplayname());
        e.setDisplayname(label);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onEvent(PlaySoundAtEntityEvent e) {
        if (!Config.playerGenders.getValue().booleanValue() || !Config.playerGenderSounds.getValue().booleanValue()) {
            return;
        }
        if (e.getEntity() == null || !(e.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)e.getEntity();
        String soundStr = e.getSound().func_187503_a().toString();
        if (!soundStr.contains("entity.player.hurt")) {
            return;
        }
        EnumAge age = Config.defaultPlayerAge.getValue();
        EnumGender gender = Config.defaultPlayerGender.getValue();
        String uuid = "" + AccessorMC.instance().getUuid(p);
        String name = AccessorMC.instance().getName(p);
        boolean isSelf = AccessorMC.instance().isSelf(p);
        age = Logic.getVisibleAge(name, uuid.toString(), isSelf, Renders.isGuiRender());
        gender = Logic.getVisibleGender(name, uuid.toString(), isSelf, Renders.isGuiRender());
        BlockPos pos = p.func_180425_c();
        Gender.client().onHurtSound(age, gender, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (!soundStr.equals("entity.player.hurt")) {
            e.setCanceled(true);
        }
    }
}

