/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.client;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.Side;
import com.github.ipixeli.gender.core.client.Asset;
import com.github.ipixeli.gender.core.client.Assets;
import com.github.ipixeli.gender.core.client.Config;
import com.github.ipixeli.gender.core.client.MCC;
import com.github.ipixeli.gender.core.profiles.BaseListMgr;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import com.github.ipixeli.gender.core.profiles.FlatList;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import java.io.File;
import java.util.Random;

public final class Client {
    private static final Random random = new Random();
    public final BaseListMgr tempMgr = new BaseListMgr(Side.TEMP, null);
    private BaseListMgr mgr;
    protected static MCC accessor;

    public Client(File modDir, MCC mcc) {
        accessor = mcc;
        new Assets();
        this.mgr = new BaseListMgr(Side.CLIENT, new FlatList(modDir, "client-profiles.txt"));
        new Config(modDir);
    }

    public final MCC accessor() {
        return accessor;
    }

    public final BaseListMgr getListManager() {
        return this.mgr;
    }

    public void onLogout() {
        this.tempMgr.clear();
    }

    public void onLogin() {
        String n = accessor.getSelfUsername();
        String u = accessor.getSelfUuid();
        if (n != null || u != null) {
            PlayerProfile p = this.mgr.getOrCreate(n, u, true);
            if (p.getAge() == EnumAge.UNSET) {
                p.setAge(EnumAge.ADULT);
            }
            if (p.getGender() == EnumGender.UNSET) {
                p.setGender(EnumGender.OTHER);
            }
            Gender.wrapper().sendProfilePacket(p);
        }
    }

    public String onHurtSound(EnumAge a, EnumGender g, float x, float y, float z) {
        float adjusted = 0.0f;
        if (a.equals(EnumAge.CHILD)) {
            adjusted = g.equals(EnumGender.FEMALE) ? 0.3f : 0.1f;
        }
        float pitch = (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f + adjusted;
        Asset sound = Assets.selectHurt(a, g);
        accessor.play(sound, pitch, x, y, z);
        return sound.getStr();
    }
}

