/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.profiles;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.Side;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import com.github.ipixeli.gender.core.profiles.EnumModel;
import com.github.ipixeli.gender.core.profiles.FlatList;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import java.util.ArrayList;
import java.util.List;

public final class BaseListMgr {
    private Side side;
    private List<PlayerProfile> list = new ArrayList<PlayerProfile>();
    private FlatList flatList;

    public BaseListMgr(Side side, FlatList fileInst) {
        this.side = side;
        if (fileInst != null) {
            this.flatList = fileInst;
            this.flatList.register(this);
        }
    }

    public final Side side() {
        return this.side;
    }

    public final void clear() {
        this.list.clear();
    }

    public final void onAttributeChangedByGUI(PlayerProfile p, boolean send) {
        if (this.flatList != null) {
            this.flatList.saveList();
        }
        if (send) {
            Gender.wrapper().sendProfilePacket(p);
        }
    }

    public final List<PlayerProfile> getList() {
        return this.list;
    }

    public final PlayerProfile get(String name, String uuid) {
        boolean validUuid;
        boolean validUsername = name != null && name.length() > 0;
        boolean bl = validUuid = uuid != null && uuid.length() > 0;
        if (validUsername || validUuid) {
            for (PlayerProfile p : this.list) {
                boolean shouldCorrectUuid;
                if ((!validUsername || !p.name().equals(name)) && (!validUuid || !p.uuid().equals(uuid))) continue;
                boolean shouldCorrectUsername = validUsername && p.name() != name;
                boolean bl2 = shouldCorrectUuid = validUuid && p.uuid() != uuid;
                if (shouldCorrectUsername) {
                    p.setUsername(name);
                } else if (shouldCorrectUuid) {
                    p.setUUID(uuid);
                }
                return p;
            }
        }
        return null;
    }

    public final PlayerProfile getOrCreate(PlayerProfile p, boolean save) {
        PlayerProfile q = this.getOrCreate(p.name(), p.uuid(), p.getAge(), p.getGender(), p.getModel(), save);
        return q;
    }

    public final PlayerProfile getOrCreate(String name, String uuid, EnumAge age, EnumGender gender, EnumModel model, boolean save) {
        boolean validUuid;
        boolean validUsername = name != null && name.length() > 0;
        boolean bl = validUuid = uuid != null && uuid.length() > 0;
        if (validUsername || validUuid) {
            PlayerProfile p = this.get(name, uuid);
            if (p == null) {
                p = new PlayerProfile("" + name, "" + uuid, age, gender, model);
                this.list.add(p);
                if (this.flatList != null && save) {
                    this.flatList.saveList();
                }
            } else {
                p.setAge(age);
                p.setGender(gender);
                p.setModel(model);
            }
            return p;
        }
        return null;
    }

    public final PlayerProfile getOrCreate(String name, String uuid, boolean save) {
        boolean validUuid;
        boolean validUsername = name != null && name.length() > 0;
        boolean bl = validUuid = uuid != null && uuid.length() > 0;
        if (validUsername || validUuid) {
            PlayerProfile p = this.get(name, uuid);
            if (p == null) {
                p = new PlayerProfile("" + name, "" + uuid);
                this.list.add(p);
                if (this.flatList != null && save) {
                    this.flatList.saveList();
                }
            }
            return p;
        }
        return null;
    }

    public final void removePlayer(int current) {
        if (this.list.size() > -1 && this.list.size() >= current && this.list.get(current) != null) {
            this.list.remove(current);
            if (this.flatList != null) {
                this.flatList.saveList();
            }
        }
    }

    public final void removePlayer(PlayerProfile p) {
        if (this.list.contains(p)) {
            this.removePlayer(this.list.indexOf(p));
        }
    }
}

