/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import oreexcavation.core.OreExcavation;
import org.apache.logging.log4j.Level;

public class JsonHelper {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static JsonArray GetArray(JsonObject json, String id) {
        if (json == null) {
            return new JsonArray();
        }
        if (json.has(id) && json.get(id).isJsonArray()) {
            return json.get(id).getAsJsonArray();
        }
        return new JsonArray();
    }

    public static JsonObject GetObject(JsonObject json, String id) {
        if (json == null) {
            return new JsonObject();
        }
        if (json.has(id) && json.get(id).isJsonObject()) {
            return json.get(id).getAsJsonObject();
        }
        return new JsonObject();
    }

    public static String GetString(JsonObject json, String id, String def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isString()) {
            return json.get(id).getAsString();
        }
        return def;
    }

    public static Number GetNumber(JsonObject json, String id, Number def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsNumber();
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public static boolean GetBoolean(JsonObject json, String id, boolean def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsBoolean();
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public static JsonObject ReadFromFile(File file) {
        if (file == null || !file.exists()) {
            return new JsonObject();
        }
        try {
            InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            JsonObject json = (JsonObject)GSON.fromJson((Reader)fr, JsonObject.class);
            fr.close();
            return json;
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.ERROR, "An error occured while loading JSON from file:", (Throwable)e);
            int i = 0;
            File bkup = new File(file.getParent(), "malformed_" + file.getName() + i + ".json");
            while (bkup.exists()) {
                bkup = new File(file.getParent(), "malformed_" + file.getName() + ++i + ".json");
            }
            OreExcavation.logger.log(Level.ERROR, "Creating backup at: " + bkup.getAbsolutePath());
            JsonHelper.CopyPaste(file, bkup);
            return new JsonObject();
        }
    }

    public static void WriteToFile(File file, JsonObject jObj) {
        try {
            if (!file.exists()) {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.ERROR, "An error occured while saving JSON to file:", (Throwable)e);
            return;
        }
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)jObj, (Appendable)fw);
            fw.flush();
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.ERROR, "An error occured while saving JSON to file:", (Throwable)e);
        }
    }

    public static void CopyPaste(File fileIn, File fileOut) {
        if (!fileIn.exists()) {
            return;
        }
        try {
            if (!fileOut.exists()) {
                if (fileOut.getParentFile() != null) {
                    fileOut.getParentFile().mkdirs();
                }
            } else {
                throw new IOException("File already exists!");
            }
            fileOut.createNewFile();
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.ERROR, "Failed copy paste", (Throwable)e);
            return;
        }
        try (BufferedReader fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileIn), StandardCharsets.UTF_8));
             BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileOut), StandardCharsets.UTF_8));){
            int read;
            char[] buffer = new char[256];
            while ((read = fr.read(buffer)) != -1) {
                fw.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.ERROR, "Failed copy paste", (Throwable)e);
        }
    }
}

