/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import net.tardis.mod.api.disguise.DisguiseRegistry;
import net.tardis.mod.cap.ITardisTracker;
import net.tardis.mod.cap.TardisTrackerCapability;
import net.tardis.mod.client.models.exteriors.TileEntityDoorTT;
import net.tardis.mod.common.ars.ConsoleRoom;
import net.tardis.mod.common.blocks.TBlocks;
import net.tardis.mod.common.commands.TardisCommand;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.entities.EntityChair;
import net.tardis.mod.common.entities.EntityCompanion;
import net.tardis.mod.common.entities.EntityCorridor;
import net.tardis.mod.common.entities.EntityCybermanInvasion;
import net.tardis.mod.common.entities.EntityDalek;
import net.tardis.mod.common.entities.EntityDalekSkaro;
import net.tardis.mod.common.entities.EntityDefabric;
import net.tardis.mod.common.entities.EntityLaserRay;
import net.tardis.mod.common.entities.EntityTardis;
import net.tardis.mod.common.entities.brak.EntityDoorsBrakSecondary;
import net.tardis.mod.common.entities.controls.ControlDimChange;
import net.tardis.mod.common.entities.controls.ControlDirection;
import net.tardis.mod.common.entities.controls.ControlDoor;
import net.tardis.mod.common.entities.controls.ControlDoorSwitch;
import net.tardis.mod.common.entities.controls.ControlFastReturn;
import net.tardis.mod.common.entities.controls.ControlFuel;
import net.tardis.mod.common.entities.controls.ControlLandType;
import net.tardis.mod.common.entities.controls.ControlLaunch;
import net.tardis.mod.common.entities.controls.ControlMag;
import net.tardis.mod.common.entities.controls.ControlMonitor;
import net.tardis.mod.common.entities.controls.ControlPhone;
import net.tardis.mod.common.entities.controls.ControlRandom;
import net.tardis.mod.common.entities.controls.ControlSonicSlot;
import net.tardis.mod.common.entities.controls.ControlStabilizers;
import net.tardis.mod.common.entities.controls.ControlTelepathicCircuts;
import net.tardis.mod.common.entities.controls.ControlWaypoint;
import net.tardis.mod.common.entities.controls.ControlX;
import net.tardis.mod.common.entities.controls.ControlY;
import net.tardis.mod.common.entities.controls.ControlZ;
import net.tardis.mod.common.entities.hellbent.EntityHellbentCorridor;
import net.tardis.mod.common.entities.hellbent.EntityHellbentDoor;
import net.tardis.mod.common.entities.vehicles.EntityBessie;
import net.tardis.mod.common.items.ItemSonic;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.protocols.ProtocolCCircuit;
import net.tardis.mod.common.protocols.ProtocolChangeInterior;
import net.tardis.mod.common.protocols.ProtocolConsole;
import net.tardis.mod.common.protocols.ProtocolEmerEscape;
import net.tardis.mod.common.protocols.ProtocolFindDimDRfit;
import net.tardis.mod.common.protocols.ProtocolForcefield;
import net.tardis.mod.common.protocols.ProtocolStealth;
import net.tardis.mod.common.protocols.ProtocolSystemReadout;
import net.tardis.mod.common.protocols.ProtocolToggleHum;
import net.tardis.mod.common.protocols.ProtocolWaypoints;
import net.tardis.mod.common.protocols.TardisProtocol;
import net.tardis.mod.common.recipes.RepairRecipes;
import net.tardis.mod.common.screwdriver.ScrewdriverHandler;
import net.tardis.mod.common.serializers.TDataSerializers;
import net.tardis.mod.common.systems.SystemAntenna;
import net.tardis.mod.common.systems.SystemCCircuit;
import net.tardis.mod.common.systems.SystemDimension;
import net.tardis.mod.common.systems.SystemFlight;
import net.tardis.mod.common.systems.SystemFluidLinks;
import net.tardis.mod.common.systems.SystemStabilizers;
import net.tardis.mod.common.systems.SystemTemporalGrace;
import net.tardis.mod.common.systems.SystemThermo;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityAlembic;
import net.tardis.mod.common.tileentity.TileEntityComponentRepair;
import net.tardis.mod.common.tileentity.TileEntityDoor;
import net.tardis.mod.common.tileentity.TileEntityEPanel;
import net.tardis.mod.common.tileentity.TileEntityEgg;
import net.tardis.mod.common.tileentity.TileEntityFoodMachine;
import net.tardis.mod.common.tileentity.TileEntityHellbentLight;
import net.tardis.mod.common.tileentity.TileEntityLight;
import net.tardis.mod.common.tileentity.TileEntityMultiblock;
import net.tardis.mod.common.tileentity.TileEntityMultiblockMaster;
import net.tardis.mod.common.tileentity.TileEntitySonicWorkbench;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.common.tileentity.TileEntityTardisCoral;
import net.tardis.mod.common.tileentity.TileEntityTractorBeam;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis01;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis02;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis03;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis04;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis05;
import net.tardis.mod.common.tileentity.decoration.TileEntityAmSphere;
import net.tardis.mod.common.tileentity.decoration.TileEntityChair;
import net.tardis.mod.common.tileentity.decoration.TileEntityHelbentRoof;
import net.tardis.mod.common.tileentity.decoration.TileEntityHellbentMonitor;
import net.tardis.mod.common.tileentity.decoration.TileEntityHellbentPole;
import net.tardis.mod.common.tileentity.decoration.TileEntityToyotaSpin;
import net.tardis.mod.common.tileentity.exteriors.TileEntityDoor01;
import net.tardis.mod.common.tileentity.exteriors.TileEntityDoor03;
import net.tardis.mod.common.tileentity.exteriors.TileEntityDoor04;
import net.tardis.mod.common.tileentity.exteriors.TileEntityDoor05;
import net.tardis.mod.common.tileentity.exteriors.TileEntityDoorCC;
import net.tardis.mod.common.tileentity.exteriors.TileEntityDoorClock;
import net.tardis.mod.common.tileentity.exteriors.TileEntityDoorWardrobe;
import net.tardis.mod.common.tileentity.exteriors.TileEntityDoorWood;
import net.tardis.mod.common.world.TardisLoadingCallback;
import net.tardis.mod.common.world.WorldGenTardis;
import net.tardis.mod.config.TardisConfig;
import net.tardis.mod.handlers.GuiHandlerTardis;
import net.tardis.mod.network.NetworkHandler;
import net.tardis.mod.proxy.ServerProxy;
import net.tardis.mod.util.common.helpers.EntityHelper;
import net.tardis.mod.util.common.helpers.FileHelper;

@Mod(modid="tardis", name="Tardis Mod", version="", dependencies="required-after:forge@[14.23.2.2638,)", acceptedMinecraftVersions="[1.12.2]")
public class Tardis {
    public static final String MODID = "tardis";
    public static final String NAME = "Tardis Mod";
    public static final String DEP = "required-after:forge@[14.23.2.2638,)";
    public static final String VERSION = "";
    public static final boolean updateChangesConfig = false;
    private static File configDir = new File(".");
    @Mod.Instance(value="tardis")
    public static Tardis instance;
    @SidedProxy(clientSide="net.tardis.mod.proxy.ClientProxy", serverSide="net.tardis.mod.proxy.ServerProxy")
    public static ServerProxy proxy;

    public static void registerTileEntity(Class<? extends TileEntity> clazz, String name) {
        GameRegistry.registerTileEntity(clazz, (ResourceLocation)new ResourceLocation(MODID, name));
    }

    public static boolean getIsDev() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        TItems.init();
        TBlocks.register();
        TDimensions.BiomeReg.init();
        EntityHelper.makeGoodBiomes();
        EntityHelper.registerStatic(ControlLaunch.class, "launch_lever");
        EntityHelper.registerStatic(ControlX.class, "x_valve");
        EntityHelper.registerStatic(ControlY.class, "y_valve");
        EntityHelper.registerStatic(ControlZ.class, "z_valve");
        EntityHelper.registerStatic(ControlDimChange.class, "dim_change");
        EntityHelper.registerStatic(ControlRandom.class, "rand_control");
        EntityHelper.registerStatic(ControlDoor.class, "tardis_door");
        EntityHelper.registerStatic(ControlFuel.class, "fuel");
        EntityHelper.registerStatic(ControlLandType.class, "land_type");
        EntityHelper.registerStatic(ControlDirection.class, "direction_control");
        EntityHelper.registerStatic(ControlFastReturn.class, "tardis_fast_return");
        EntityHelper.registerStatic(ControlTelepathicCircuts.class, "telepathic_circuts");
        EntityHelper.registerStatic(ControlDoorSwitch.class, "tardis_door_control");
        EntityHelper.registerStatic(ControlPhone.class, "tardis_phone");
        EntityHelper.registerStatic(ControlMag.class, "tardis_magnitude");
        EntityHelper.registerStatic(ControlSonicSlot.class, "sonic_slot");
        EntityHelper.registerStatic(ControlStabilizers.class, "stabilizers");
        EntityHelper.registerStatic(ControlMonitor.class, "monitor");
        EntityHelper.registerStatic(ControlWaypoint.class, "waypoint_select");
        EntityHelper.registerProjectiles(EntityLaserRay.class, "cyber_ray");
        EntityHelper.registerNoSpawn(EntityCorridor.class, "toyota_corridor");
        EntityHelper.registerNoSpawn(EntityHellbentCorridor.class, "hellbent_corridor");
        EntityHelper.registerNoSpawn(EntityHellbentDoor.class, "hellbent_door");
        EntityHelper.registerNoSpawn(EntityBessie.class, "bessie");
        EntityHelper.registerNoSpawn(EntityCompanion.class, "companion");
        EntityHelper.registerNoSpawn(EntityDalekSkaro.class, "dalek_scaro");
        EntityHelper.registerStatic(EntityChair.class, "chair");
        EntityHelper.registerStatic(EntityDoorsBrakSecondary.class, "doors_brak_second");
        EntityHelper.registerNoSpawn(EntityTardis.class, MODID);
        EntityHelper.registerProjectiles(EntityDefabric.class, "defabric");
        Tardis.registerTileEntity(TileEntityTardis.class, "TileEntityTardis");
        Tardis.registerTileEntity(TileEntityDoor.class, "TileEntityDoor");
        Tardis.registerTileEntity(TileEntityAlembic.class, "TileEntityAlembic");
        Tardis.registerTileEntity(TileEntityFoodMachine.class, "TileEntityFoodMachine");
        Tardis.registerTileEntity(TileEntityEPanel.class, "TileEntityEPanel");
        Tardis.registerTileEntity(TileEntityTardisCoral.class, "TileEntityTardisCoral");
        Tardis.registerTileEntity(TileEntityLight.class, "TileEntityLight");
        Tardis.registerTileEntity(TileEntityHellbentLight.class, "TileEntityHellbentLight");
        Tardis.registerTileEntity(TileEntityHellbentMonitor.class, "TileEntityHellbentMonitor");
        Tardis.registerTileEntity(TileEntityHellbentPole.class, "TileEntityHellbentPole");
        Tardis.registerTileEntity(TileEntityHelbentRoof.class, "TileEntityHelbentRoof");
        Tardis.registerTileEntity(TileEntityComponentRepair.class, "TileEntityComponentRepair");
        Tardis.registerTileEntity(TileEntityChair.class, "chair");
        Tardis.registerTileEntity(TileEntityAmSphere.class, "am_sphere");
        Tardis.registerTileEntity(TileEntityToyotaSpin.class, "toyota_spinnything");
        Tardis.registerTileEntity(TileEntityMultiblockMaster.class, "multi_master");
        Tardis.registerTileEntity(TileEntityMultiblock.class, "multi");
        Tardis.registerTileEntity(TileEntityDoor01.class, "TileEntityDoor01");
        Tardis.registerTileEntity(TileEntityDoor03.class, "TileEntityDoor03");
        Tardis.registerTileEntity(TileEntityDoor04.class, "TileEntityDoor04");
        Tardis.registerTileEntity(TileEntityDoor05.class, "TileEntityDoor05");
        Tardis.registerTileEntity(TileEntityDoorCC.class, "TileEntityDoorCC");
        Tardis.registerTileEntity(TileEntityDoorClock.class, "TileEntityDoorClock");
        Tardis.registerTileEntity(TileEntityDoorTT.class, "TileEntityDoorTT");
        Tardis.registerTileEntity(TileEntityDoorWood.class, "TileEntityDoorWood");
        Tardis.registerTileEntity(TileEntityDoorWardrobe.class, "exterior_wardrobe");
        Tardis.registerTileEntity(TileEntityTardis01.class, "TileEntityTardis01");
        Tardis.registerTileEntity(TileEntityTardis02.class, "TileEntityTardis02");
        Tardis.registerTileEntity(TileEntityTardis03.class, "console_3");
        Tardis.registerTileEntity(TileEntityTardis04.class, "console_4");
        Tardis.registerTileEntity(TileEntityTardis05.class, "console_5");
        Tardis.registerTileEntity(TileEntitySonicWorkbench.class, "sonic_workbench");
        Tardis.registerTileEntity(TileEntityEgg.class, "ars_egg");
        Tardis.registerTileEntity(TileEntityTractorBeam.class, "tractor_beam");
        NetworkHandler.init();
        ScrewdriverHandler.init();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new TardisLoadingCallback());
        TardisProtocol.register(new ProtocolEmerEscape());
        TardisProtocol.register(new ProtocolCCircuit());
        TardisProtocol.register(new ProtocolSystemReadout());
        TardisProtocol.register(new ProtocolConsole());
        if (Loader.isModLoaded((String)"dimdoors")) {
            TardisProtocol.register(new ProtocolFindDimDRfit());
        }
        TardisProtocol.register(new ProtocolWaypoints());
        TardisProtocol.register(new ProtocolToggleHum());
        TardisProtocol.register(new ProtocolChangeInterior());
        TardisProtocol.register(new ProtocolStealth());
        TardisProtocol.register(new ProtocolForcefield());
        EntityHelper.registerMobEgg(EntityCybermanInvasion.class, "invasion_cyberman", TardisConfig.USE_ENTITIES.cybermanSpawnChance, 5, 4);
        EntityHelper.registerNoSpawnEgg(EntityDalek.class, "dalek", 9075240, 5583904);
        proxy.preInit();
        TardisSystems.register("flight", SystemFlight.class);
        TardisSystems.register("dimensional", SystemDimension.class);
        TardisSystems.register("fluid_links", SystemFluidLinks.class);
        TardisSystems.register("antenna", SystemAntenna.class);
        TardisSystems.register("chameleon", SystemCCircuit.class);
        TardisSystems.register("temporal_grace", SystemTemporalGrace.class);
        TardisSystems.register("stabilizers", SystemStabilizers.class);
        TardisSystems.register("thermo", SystemThermo.class);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenTardis(), (int)1);
        DisguiseRegistry.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandlerTardis());
        RepairRecipes.registerRecipe(TItems.fluid_link, TItems.mercuryBottle);
        RepairRecipes.registerRecipe(TItems.demat_circut, Items.field_151079_bi);
        RepairRecipes.registerRecipe(TItems.antenna, TItems.circuts);
        RepairRecipes.registerRecipe(TItems.stabilizers, TItems.circuts);
        RepairRecipes.registerRecipe(TItems.time_vector_generator, Items.field_151079_bi);
        RepairRecipes.registerRecipe(TItems.chameleon_circuit, TItems.circuts);
        RepairRecipes.registerRecipe(TItems.temporal_grace_circuits, Items.field_185159_cQ);
        RepairRecipes.registerRecipe(TItems.thermo, Items.field_151042_j);
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_0.png", "interior/interior_0", new BlockPos(10, 2, 9));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_1.png", "interior/interior_1", new BlockPos(9, 2, 9));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_greymatter.png", "interior/interior_greymatter", new BlockPos(17, 2, 17));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_study.png", "interior/interior_study", new BlockPos(14, 2, 8));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_lodge.png", "interior/interior_lodge", new BlockPos(17, 2, 17));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_aquatic.png", "interior/interior_aquatic", new BlockPos(19, 2, 18));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_industrial.png", "interior/interior_industrial", new BlockPos(11, 2, 18));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_helian.png", "interior/interior_helian", new BlockPos(18, 1, 18));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_magmatic.png", "interior/interior_magmatic", new BlockPos(21, 3, 16));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_explorer.png", "interior/interior_explorer", new BlockPos(23, 3, 20));
        ConsoleRoom.registerConsoleRoom("textures/gui/previews/preview_builder.png", "interior/interior_builder", new BlockPos(9, 1, 9));
        TileEntitySonicWorkbench.RECIPES.put(TItems.key, new Item[]{TItems.key_01});
        Item[] sonics = new Item[ItemSonic.SONICS.size()];
        for (int sonicID = 0; sonicID < sonics.length; ++sonicID) {
            sonics[sonicID] = ItemSonic.SONICS.get(sonicID);
        }
        TileEntitySonicWorkbench.RECIPES.put(TItems.sonic_screwdriver, sonics);
        TileEntitySonicWorkbench.RECIPES.put(Item.func_150898_a((Block)Blocks.field_150325_L), new Item[]{TItems.void_specs});
        configDir = event.getModConfigurationDirectory();
        CapabilityManager.INSTANCE.register(ITardisTracker.class, (Capability.IStorage)new ITardisTracker.TardisTrackerStorage(), TardisTrackerCapability::new);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        OreDictionary.registerOre((String)"oreUranium", (Item)TItems.power_cell);
        OreDictionary.registerOre((String)"dustCinnabar", (Item)TItems.crushedCinnabar);
        OreDictionary.registerOre((String)"oreCinnabar", (Block)TBlocks.cinnabar_ore);
        PermissionAPI.registerNode((String)"tardis.command.tardistp", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows players to teleport themself in their TARDIS");
        PermissionAPI.registerNode((String)"tardis.command.tardistp.other", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows players to teleport themself in the TARDIS of a specified player");
        PermissionAPI.registerNode((String)"tardis.command.removetardis", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows players to delete a TARDIS");
        PermissionAPI.registerNode((String)"tardis.command.restoretardis", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows players to restore their TARDIS Systems");
        PermissionAPI.registerNode((String)"tardis.command.grow", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows players to grow their TARDIS Coral faster");
        PermissionAPI.registerNode((String)"tardis.command.exterior", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows players to teleport themself out of their TARDIS");
        TDimensions.register();
        DataSerializers.func_187189_a(TDataSerializers.VEC3D);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        for (ItemStack cinnabar : OreDictionary.getOres((String)"dustCinnabar")) {
            TileEntityAlembic.AlembicRecipe.registerRecipe(cinnabar.func_77973_b(), TItems.mercuryBottle);
        }
        FileHelper.readOrWriteARS(configDir);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new TardisCommand());
    }
}

