/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.worldshell;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class BlockStorage {
    public IBlockState blockstate;
    public NBTTagCompound tileentity = null;
    public int light;

    public BlockStorage() {
    }

    public BlockStorage(IBlockState b, TileEntity t, int l) {
        this.blockstate = b;
        if (t != null) {
            this.tileentity = t.serializeNBT();
        }
        this.light = l;
    }

    public BlockStorage(ByteBuf buf) {
        this.fromBuf(buf);
    }

    public void toBuf(ByteBuf buf) {
        buf.writeInt(Block.func_176210_f((IBlockState)this.blockstate));
        buf.writeInt(this.light);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tileentity);
    }

    public void fromBuf(ByteBuf buf) {
        this.blockstate = Block.func_176220_d((int)buf.readInt());
        this.light = buf.readInt();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (tag != null) {
            this.tileentity = tag;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BlockStorage)) {
            return false;
        }
        BlockStorage stor = (BlockStorage)other;
        if (this.blockstate.equals(stor.blockstate) && this.light == stor.light && (this.tileentity == null && stor.tileentity == null || this.tileentity.equals((Object)stor.tileentity))) {
            return true;
        }
        return super.equals(other);
    }
}

