/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.worldshell;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.client.worldshell.BlockStorage;
import net.tardis.mod.client.worldshell.IContainsWorldShell;
import net.tardis.mod.client.worldshell.PlayerStorage;
import net.tardis.mod.client.worldshell.RenderWorldShell;
import net.tardis.mod.client.worldshell.WorldShell;

public class MessageSyncWorldShell
implements IMessage {
    public WorldShell worldShell;
    public BlockPos tilePos = BlockPos.field_177992_a;
    public int id = -1;
    public EnumType type;

    public MessageSyncWorldShell(WorldShell ws, int id, EnumType type) {
        this.id = id;
        this.worldShell = ws;
        this.type = type;
    }

    public MessageSyncWorldShell(WorldShell ws, BlockPos pos, EnumType type) {
        this.tilePos = pos.func_185334_h();
        this.worldShell = ws;
        this.id = -1;
        this.type = type;
    }

    public MessageSyncWorldShell() {
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int size;
        this.id = buf.readInt();
        this.tilePos = BlockPos.func_177969_a((long)buf.readLong());
        this.worldShell = new WorldShell(BlockPos.func_177969_a((long)buf.readLong()));
        this.worldShell.setTime(buf.readLong());
        this.type = EnumType.values()[buf.readInt()];
        if (this.type == EnumType.BLOCKS) {
            size = buf.readInt();
            for (int i2 = 0; i2 < size; ++i2) {
                this.worldShell.blockMap.put(BlockPos.func_177969_a((long)buf.readLong()), new BlockStorage(buf));
            }
        }
        if (this.type == EnumType.ENTITITES) {
            size = buf.readInt();
            ArrayList<NBTTagCompound> entities = new ArrayList<NBTTagCompound>();
            for (i = 0; i < size; ++i) {
                entities.add(ByteBufUtils.readTag((ByteBuf)buf));
            }
            this.worldShell.setEntities(entities);
        }
        if (this.type == EnumType.PLAYERS) {
            size = buf.readInt();
            ArrayList<PlayerStorage> players = new ArrayList<PlayerStorage>();
            for (i = 0; i < size; ++i) {
                players.add(PlayerStorage.fromBytes(buf));
            }
            this.worldShell.setPlayers(players);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeLong(this.tilePos.func_177986_g());
        buf.writeLong(this.worldShell.getOffset().func_177986_g());
        buf.writeLong(this.worldShell.getTime());
        buf.writeInt(this.type.ordinal());
        if (this.type == EnumType.BLOCKS) {
            buf.writeInt(this.worldShell.blockMap.size());
            for (Map.Entry<BlockPos, BlockStorage> stor : this.worldShell.blockMap.entrySet()) {
                buf.writeLong(stor.getKey().func_177986_g());
                stor.getValue().toBuf(buf);
            }
        }
        if (this.type == EnumType.ENTITITES) {
            buf.writeInt(this.worldShell.getEntities().size());
            for (NBTTagCompound e : this.worldShell.getEntities()) {
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)e);
            }
        }
        if (this.type == EnumType.PLAYERS) {
            buf.writeInt(this.worldShell.getPlayers().size());
            for (PlayerStorage ps : this.worldShell.getPlayers()) {
                ps.toBytes(buf);
            }
        }
    }

    public static enum EnumType {
        BLOCKS,
        ENTITITES,
        PLAYERS;

    }

    public static class Handler
    implements IMessageHandler<MessageSyncWorldShell, IMessage> {
        public IMessage onMessage(final MessageSyncWorldShell mes, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    RenderWorldShell.BOTI = null;
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    if (mes == null || world == null) {
                        return;
                    }
                    if (mes.id == -1) {
                        TileEntity te = world.func_175625_s(mes.tilePos);
                        if (te != null && te instanceof IContainsWorldShell) {
                            IContainsWorldShell cont = (IContainsWorldShell)te;
                            if (!cont.getWorldShell().getOffset().equals((Object)mes.worldShell.getOffset())) {
                                cont.setWorldShell(mes.worldShell);
                            } else {
                                Handler.combineWorldShell(cont, mes.worldShell, mes.type);
                            }
                        }
                    } else {
                        Entity entity = world.func_73045_a(mes.id);
                        if (entity != null && entity instanceof IContainsWorldShell) {
                            IContainsWorldShell cont = (IContainsWorldShell)entity;
                            if (!cont.getWorldShell().getOffset().equals((Object)mes.worldShell.getOffset())) {
                                cont.setWorldShell(mes.worldShell);
                            } else {
                                Handler.combineWorldShell(cont, mes.worldShell, mes.type);
                            }
                        }
                    }
                }
            });
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public static void combineWorldShell(IContainsWorldShell cont, WorldShell shell, EnumType type) {
            cont.getWorldShell().setTime(shell.getTime());
            if (type == EnumType.BLOCKS) {
                cont.getWorldShell().blockMap.putAll(shell.blockMap);
                cont.getWorldShell().setTESRs((World)(cont.getRenderWorld() != null ? cont.getRenderWorld() : Minecraft.func_71410_x().field_71441_e));
            } else if (type == EnumType.ENTITITES) {
                cont.getWorldShell().getEntitiesForRender().clear();
                cont.getWorldShell().setEntities(shell.getEntities());
                cont.getWorldShell().setEntities((World)(cont.getRenderWorld() != null ? cont.getRenderWorld() : Minecraft.func_71410_x().field_71441_e));
            }
        }
    }
}

