/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.commands.subcommands;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.tardis.mod.common.commands.TardisCommand;
import net.tardis.mod.common.commands.subcommands.CommandTemplate;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.util.common.helpers.FileHelper;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class CommandRemove
extends CommandTemplate {
    public CommandRemove(TardisCommand parent, @Nullable String permission) {
        super(parent, permission);
    }

    public String func_71517_b() {
        return "remove";
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return super.func_71518_a(sender) + " <username>";
    }

    @Override
    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return super.func_184882_a(server, sender) || sender instanceof MinecraftServer;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        String toBeRemoved = args[0];
        Map<UUID, String> playersMap = FileHelper.getPlayersFromServerFile();
        if (playersMap.containsValue(toBeRemoved)) {
            UUID toBeRemovedID = Helper.getKeyByValue(playersMap, toBeRemoved);
            if (toBeRemovedID != null) {
                if (TardisHelper.hasTardis(toBeRemovedID)) {
                    server.func_71218_a(TDimensions.TARDIS_ID).func_175698_g(TardisHelper.getTardis(toBeRemovedID));
                    TardisHelper.tardisOwners.remove(toBeRemovedID.toString());
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.tardis_deleted", new Object[0]));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.no_tardis_owned", new Object[0]));
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.no_player_found", new Object[0]));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return CommandRemove.func_175762_a((String[])args, FileHelper.getPlayersFromServerFile().values());
    }
}

