/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.commands.subcommands;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.tardis.mod.common.commands.TardisCommand;
import net.tardis.mod.common.commands.subcommands.CommandTemplate;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.FileHelper;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class CommandTeleport
extends CommandTemplate {
    public CommandTeleport(TardisCommand parent, @Nullable String permission) {
        super(parent, permission);
    }

    public String func_71517_b() {
        return "interior";
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return super.func_71518_a(sender) + "| <username>";
    }

    @Override
    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayerMP)) {
            throw new CommandException("You are not a player. You must run these commands in game.", new Object[0]);
        }
        EntityPlayerMP player = CommandTeleport.func_71521_c((ICommandSender)sender);
        if (args.length >= 1 && PermissionAPI.hasPermission((EntityPlayer)player, (String)"tardis.command.tardistp.other")) {
            this.handleTeleport(player, args[0]);
        } else if (PermissionAPI.hasPermission((EntityPlayer)player, (String)"tardis.command.tardistp")) {
            this.handleTeleport(player, null);
        } else {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
    }

    private void handleTeleport(EntityPlayerMP player, @Nullable String tardisOwner) {
        UUID playerID;
        MinecraftServer server = player.func_184102_h();
        if (tardisOwner == null) {
            playerID = player.func_110124_au();
        } else {
            Map<UUID, String> playersMap = FileHelper.getPlayersFromServerFile();
            playerID = Helper.getKeyByValue(playersMap, tardisOwner);
        }
        if (playerID != null) {
            if (TardisHelper.hasTardis(playerID)) {
                BlockPos pos = TardisHelper.getTardis(playerID);
                player.func_184210_p();
                WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(TDimensions.TARDIS_ID);
                TileEntityTardis tileTardis = (TileEntityTardis)worldServer.func_175625_s(pos);
                if (tileTardis != null) {
                    tileTardis.enterTARDIS((Entity)player);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("command.no_tardis_owned but most likely a issue has arisen somewhere...", new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.no_tardis_owned", new Object[0]));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.no_player_found", new Object[0]));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return CommandTeleport.func_175762_a((String[])args, FileHelper.getPlayersFromServerFile().values());
    }
}

