/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.dimensions.gallifrey;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.dimensions.gallifrey.GenLayerGallifreyBiomes;

public class GallifreyBiomeProvider
extends BiomeProvider {
    public static final List<Biome> BIOMES_TO_SPAWN_IN = Lists.newArrayList((Object[])new Biome[]{TDimensions.BIOME_GALLIFREY_REDLANDS, TDimensions.BIOME_GALLIFREY_MOUNTAIN});

    public GallifreyBiomeProvider(World world) {
        super(world.func_72912_H());
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        GenLayer generationLayer = GallifreyBiomeProvider.buildBiomeProcedure(seed);
        GenLayerVoronoiZoom layer = new GenLayerVoronoiZoom(10L, generationLayer);
        layer.func_75905_a(seed);
        GenLayer[] layers = new GenLayer[]{generationLayer, layer, generationLayer};
        return super.getModdedBiomeGenerators(worldType, seed, layers);
    }

    private static GenLayer buildBiomeProcedure(long seed) {
        GenLayerGallifreyBiomes layer = new GenLayerGallifreyBiomes(seed);
        layer = new GenLayerZoom(1000L, (GenLayer)layer);
        layer = new GenLayerZoom(1000L, (GenLayer)layer);
        layer = new GenLayerZoom(1000L, (GenLayer)layer);
        layer = new GenLayerZoom(1000L, (GenLayer)layer);
        layer = new GenLayerZoom(1000L, (GenLayer)layer);
        layer = new GenLayerFuzzyZoom(1000L, (GenLayer)layer);
        return layer;
    }

    public List<Biome> func_76932_a() {
        return BIOMES_TO_SPAWN_IN;
    }
}

