/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.dimensions.gallifrey.biomes;

import java.util.Random;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.tardis.mod.common.blocks.TBlocks;

public class BiomeMountains
extends Biome {
    private static final IBlockState GRASS = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
    private static final ResourceLocation[] treeList = new ResourceLocation[]{new ResourceLocation("tardis", "gallifrey/trees/gal_tree_large"), new ResourceLocation("tardis", "gallifrey/trees/gal_tree_tall"), new ResourceLocation("tardis", "gallifrey/trees/gal_tree_normal"), new ResourceLocation("tardis", "gallifrey/trees/gal_tree_small"), new ResourceLocation("tardis", "gallifrey/trees/gal_tree_small_skinny"), new ResourceLocation("tardis", "gallifrey/trees/gal_shrub")};

    public BiomeMountains() {
        super(new Biome.BiomeProperties("Red Mountains").func_185398_c(0.4f).func_185400_d(0.6f).func_185410_a(0.0f).func_185402_a(15426109).func_185411_b());
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 20, 2, 3));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntitySheep.class, 20, 2, 3));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityPig.class, 20, 2, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 25, 1, 4));
        this.field_76760_I = new BiomeDecoratorGallifrey();
        this.field_76760_I.field_76832_z = 30;
        this.field_76760_I.field_189870_A = 0.05f;
        this.field_76760_I.field_76802_A = 4;
        this.field_76760_I.field_76803_B = 10;
    }

    public int func_180627_b(BlockPos pos) {
        return this.getModdedBiomeGrassColor(15158332);
    }

    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(0xEAEDED);
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double stoneNoiseVal) {
        IBlockState topBlock = TBlocks.gallifreyan_grass_snow.func_176223_P();
        IBlockState fillerBlock = TBlocks.gallifreyan_dirt.func_176223_P();
        IBlockState seaFloorBlock = TBlocks.gallifreyan_stone.func_176223_P();
        boolean hitFloorYet = false;
        int topBlocksToFill = 0;
        int dirtBlocksToFill = 0;
        int seaFloorBlocksToFill = 0;
        int dirtDepth = Math.max(0, (int)(stoneNoiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25));
        int seaFloorDepth = 1 + rand.nextInt(2);
        int localX = x & 0xF;
        int localZ = z & 0xF;
        for (int y = 255; y >= 0; --y) {
            IBlockState state = primer.func_177856_a(localZ, y, localX);
            if (y <= rand.nextInt(5)) {
                primer.func_177855_a(localZ, y, localX, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            if (state.func_185904_a() == Material.field_151579_a) {
                topBlocksToFill = topBlock == null ? 0 : 1;
                dirtBlocksToFill = dirtDepth;
                continue;
            }
            if (!hitFloorYet && state.func_185904_a() == Material.field_151586_h) {
                seaFloorBlocksToFill = seaFloorDepth;
            }
            if (state.func_177230_c() != Blocks.field_150348_b) continue;
            hitFloorYet = true;
            if (topBlocksToFill > 0) {
                if (y >= 62) {
                    primer.func_177855_a(localZ, y, localX, topBlock);
                } else if (y >= 56 - dirtDepth) {
                    primer.func_177855_a(localZ, y, localX, fillerBlock);
                } else {
                    primer.func_177855_a(localZ, y, localX, Blocks.field_150351_n.func_176223_P());
                    dirtBlocksToFill = 0;
                }
                --topBlocksToFill;
                continue;
            }
            if (seaFloorBlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, seaFloorBlock);
                --seaFloorBlocksToFill;
                continue;
            }
            if (dirtBlocksToFill <= 0) continue;
            primer.func_177855_a(localZ, y, localX, fillerBlock);
            --dirtBlocksToFill;
        }
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        return null;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int maxTrees = rand.nextInt(3);
        for (int trees = 0; trees < maxTrees; ++trees) {
            BlockPos treePos = worldIn.func_175672_r(pos.func_177982_a(rand.nextInt(14) + 8, 0, rand.nextInt(14) + 8));
            if (worldIn.func_180495_p(treePos.func_177977_b()).func_177230_c() != TBlocks.gallifreyan_grass_snow) continue;
            BiomeMountains.generateGallifreyTrees(worldIn, worldIn.func_175672_r(treePos), treeList[rand.nextInt(treeList.length)]);
        }
    }

    public static void generateGallifreyTrees(World world, BlockPos pos, ResourceLocation location) {
        Template treeTemp;
        BlockPos treePos;
        if (!world.field_72995_K && world.func_180495_p(treePos = pos.func_177982_a(-(treeTemp = ((WorldServer)world).func_184163_y().func_189942_b(world.func_73046_m(), location)).func_186259_a().func_177958_n() / 2, 0, -treeTemp.func_186259_a().func_177952_p() / 2)).isSideSolid((IBlockAccess)world, treePos, EnumFacing.UP)) {
            treeTemp.func_186253_b(world, treePos, new PlacementSettings());
        }
    }

    public static class BiomeDecoratorGallifrey
    extends BiomeDecorator {
        public ChunkGeneratorSettings field_180293_d;
        public WorldGenerator field_76821_k;
        public WorldGenerator field_76818_l;
        public WorldGenerator field_76831_p;
        public WorldGenerator field_76819_m;
        public WorldGenerator field_180299_p;
        public WorldGenerator field_180298_q;

        public void func_180292_a(World worldIn, Random random, Biome biome, BlockPos pos) {
            this.field_76821_k = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), this.field_180293_d.field_177844_ac);
            this.field_76818_l = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), this.field_180293_d.field_177848_ag);
            this.field_76819_m = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), this.field_180293_d.field_177828_ak);
            this.field_180299_p = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), this.field_180293_d.field_177836_ao);
            this.field_180298_q = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), this.field_180293_d.field_177814_as);
            this.field_76831_p = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), this.field_180293_d.field_177822_aw);
        }

        protected void func_150513_a(Biome biomeIn, World worldIn, Random random) {
        }
    }
}

