/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.dimensions.gallifrey.biomes;

import java.util.Random;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.tardis.mod.common.blocks.TBlocks;

public class BiomeWastelands
extends Biome {
    protected static final IBlockState GRASS = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
    protected static final IBlockState SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    protected static final IBlockState DIRT = TBlocks.gallifreyan_dirt.func_176223_P();
    protected static final ResourceLocation[] BARNS = new ResourceLocation[]{new ResourceLocation("tardis", "gallifrey/barn_one")};

    public BiomeWastelands() {
        super(new Biome.BiomeProperties("Wastelands").func_185398_c(0.0f).func_185400_d(0.0f).func_185410_a(6.0f).func_185396_a().func_185402_a(16224000));
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 25, 1, 4));
    }

    public int func_180627_b(BlockPos pos) {
        return this.getModdedBiomeGrassColor(11510889);
    }

    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(0xEAEDED);
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double stoneNoiseVal) {
        IBlockState topBlock = TBlocks.gallifreyan_sand.func_176223_P();
        IBlockState fillerBlock = TBlocks.gallifreyan_dirt.func_176223_P();
        IBlockState seaFloorBlock = TBlocks.gallifreyan_stone.func_176223_P();
        boolean hitFloorYet = false;
        int topBlocksToFill = 0;
        int dirtBlocksToFill = 0;
        int seaFloorBlocksToFill = 0;
        int dirtDepth = Math.max(0, (int)(stoneNoiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25));
        int seaFloorDepth = 1 + rand.nextInt(2);
        int localX = x & 0xF;
        int localZ = z & 0xF;
        for (int y = 255; y >= 0; --y) {
            IBlockState state = primer.func_177856_a(localZ, y, localX);
            if (y <= rand.nextInt(5)) {
                primer.func_177855_a(localZ, y, localX, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            if (state.func_185904_a() == Material.field_151579_a) {
                topBlocksToFill = topBlock == null ? 0 : 1;
                dirtBlocksToFill = dirtDepth;
                continue;
            }
            if (!hitFloorYet && state.func_185904_a() == Material.field_151586_h) {
                seaFloorBlocksToFill = seaFloorDepth;
            }
            if (state.func_177230_c() != Blocks.field_150348_b) continue;
            hitFloorYet = true;
            if (topBlocksToFill > 0) {
                if (y >= 62) {
                    primer.func_177855_a(localZ, y, localX, topBlock);
                } else if (y >= 56 - dirtDepth) {
                    primer.func_177855_a(localZ, y, localX, fillerBlock);
                } else {
                    primer.func_177855_a(localZ, y, localX, Blocks.field_150351_n.func_176223_P());
                    dirtBlocksToFill = 0;
                }
                --topBlocksToFill;
                continue;
            }
            if (seaFloorBlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, seaFloorBlock);
                --seaFloorBlocksToFill;
                continue;
            }
            if (dirtBlocksToFill <= 0) continue;
            primer.func_177855_a(localZ, y, localX, fillerBlock);
            --dirtBlocksToFill;
        }
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int maxSandStone = 100;
        for (int sandstone = 0; sandstone < maxSandStone; ++sandstone) {
            BlockPos sstonePos = worldIn.func_175672_r(pos.func_177982_a(rand.nextInt(16), 0, rand.nextInt(16)));
            if (worldIn.func_180495_p(sstonePos.func_177977_b()).func_177230_c() != TBlocks.gallifreyan_sand) continue;
            worldIn.func_175656_a(sstonePos.func_177977_b(), SANDSTONE);
        }
        int maxDirt = 25;
        for (int dirt = 0; dirt < maxDirt; ++dirt) {
            BlockPos dirtPos = worldIn.func_175672_r(pos.func_177982_a(rand.nextInt(16), 0, rand.nextInt(16)));
            if (worldIn.func_180495_p(dirtPos.func_177977_b()).func_177230_c() != TBlocks.gallifreyan_sand) continue;
            worldIn.func_175656_a(dirtPos.func_177977_b(), DIRT);
        }
        int maxGrass = 16;
        for (int grass = 0; grass < maxGrass; ++grass) {
            BlockPos grassPos = worldIn.func_175672_r(pos.func_177982_a(rand.nextInt(14), 0, rand.nextInt(14)));
            if (worldIn.func_180495_p(grassPos.func_177977_b()).func_177230_c() != TBlocks.gallifreyan_dirt) continue;
            worldIn.func_175656_a(grassPos, GRASS);
        }
        int maxSkull = 1;
        for (int skull = 0; skull < maxSkull; ++skull) {
            int percentageSpawn = rand.nextInt(100);
            if (percentageSpawn != 1) continue;
            BlockPos skullPos = worldIn.func_175672_r(pos.func_177982_a(rand.nextInt(16), 0, rand.nextInt(16)));
            worldIn.func_175656_a(skullPos, Blocks.field_150465_bP.func_176223_P().func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)BiomeWastelands.randomEnum(EnumFacing.class, rand)));
        }
        int maxBarns = rand.nextInt(2);
        for (int barns = 0; barns < maxBarns; ++barns) {
            int x = rand.nextInt(15);
            int z = rand.nextInt(15);
            BlockPos barnPos = worldIn.func_175672_r(pos.func_177982_a(rand.nextInt(14), 0, rand.nextInt(14)));
            int barnChance = rand.nextInt(1000);
            if (barnChance != 1) continue;
            BiomeWastelands.generateGallifreySheds(worldIn, worldIn.func_175672_r(barnPos), BARNS[rand.nextInt(BARNS.length)]);
        }
    }

    public static void generateGallifreySheds(World world, BlockPos pos, ResourceLocation location) {
        Template shedTemp;
        BlockPos shedPos;
        if (!world.field_72995_K && world.func_180495_p(shedPos = pos.func_177982_a(-(shedTemp = ((WorldServer)world).func_184163_y().func_189942_b(world.func_73046_m(), location)).func_186259_a().func_177958_n() / 2, -1, -shedTemp.func_186259_a().func_177952_p() / 2)).isSideSolid((IBlockAccess)world, shedPos, EnumFacing.UP)) {
            shedTemp.func_186253_b(world, shedPos, new PlacementSettings());
        }
    }

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz, Random random) {
        int x = random.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }
}

