/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.dimensions.moon;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.api.dimensions.IDimensionProperties;
import net.tardis.mod.client.renderers.sky.SkyRendererMoon;
import net.tardis.mod.common.dimensions.IPopulatable;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.dimensions.moon.GenCrater;
import net.tardis.mod.common.dimensions.telos.ChunkGeneratorTelos;

public class MoonProvider
extends WorldProvider
implements IDimensionProperties {
    private static BiomeProviderSingle biomeP = new BiomeProviderSingle(TDimensions.BIOME_MOON);

    public DimensionType func_186058_p() {
        return TDimensions.MOON_TYPE;
    }

    public BiomeProvider func_177499_m() {
        return biomeP;
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorTelos(this.field_76579_a, this.getSeed(), new IPopulatable(){
            GenCrater gen = new GenCrater();

            @Override
            public void gen(World world, Random rand, int x, int z) {
                if (rand.nextInt(100) <= 5) {
                    int size = 5 + rand.nextInt(10);
                    BlockPos pos = world.func_175672_r(new BlockPos(x * 16, 0, z * 16)).func_177982_a(16, size / 2, 16);
                    this.gen.genCrater(world, pos, size);
                }
            }
        });
    }

    public boolean func_76569_d() {
        return false;
    }

    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public boolean func_76561_g() {
        return false;
    }

    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return new SkyRendererMoon();
    }

    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }

    @Override
    public boolean hasGravity() {
        return false;
    }

    @Override
    public boolean hasAir() {
        return false;
    }

    @Override
    public int getRadiationLevels() {
        return 0;
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return WorldProvider.WorldSleepResult.ALLOW;
    }

    @Override
    public double transformGrav(double motionY) {
        return motionY + 0.05;
    }
}

