/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities.controls;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tardis.mod.common.entities.EntityCompanion;
import net.tardis.mod.common.entities.EntityDalek;
import net.tardis.mod.common.entities.controls.EntityControl;
import net.tardis.mod.common.enums.EnumEvent;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.systems.SystemAntenna;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis01;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis02;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis03;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis04;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis05;
import net.tardis.mod.config.TardisConfig;
import net.tardis.mod.util.common.helpers.Helper;

public class ControlPhone
extends EntityControl {
    public ControlPhone(TileEntityTardis tardis) {
        super(tardis);
        this.func_70105_a(Helper.precentToPixels(2.0f), Helper.precentToPixels(2.0f));
    }

    public ControlPhone(World world) {
        super(world);
    }

    @Override
    public Vec3d getOffset(TileEntityTardis tardis) {
        if (((Object)((Object)tardis)).getClass() == TileEntityTardis01.class || ((Object)((Object)tardis)).getClass() == TileEntityTardis02.class) {
            return Helper.convertToPixels(0.0, -2.0, 8.0);
        }
        if (tardis instanceof TileEntityTardis03) {
            return Helper.convertToPixels(-11.5, 1.0, 9.5);
        }
        if (tardis instanceof TileEntityTardis04) {
            return Helper.convertToPixels(-12.0, -3.0, -7.0);
        }
        if (tardis instanceof TileEntityTardis05) {
            return Helper.convertToPixels(0.0, -3.0, -10.5);
        }
        return Helper.convertToPixels(0.0, -1.0, -8.0);
    }

    @Override
    public void preformAction(EntityPlayer player) {
        TileEntityTardis tardis = (TileEntityTardis)this.field_70170_p.func_175625_s(this.getConsolePos());
        if (!this.field_70170_p.field_72995_K && tardis.currentEvent == EnumEvent.DALEK) {
            this.genDalekInvasion(player);
        }
    }

    @Override
    public void func_70071_h_() {
        TileEntityTardis tardis;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && TardisConfig.MISC.invasions && (tardis = (TileEntityTardis)this.field_70170_p.func_175625_s(this.getConsolePos())) != null) {
            SystemAntenna sys = tardis.getSystem(SystemAntenna.class);
            if (sys != null && sys.getHealth() > 0.0f) {
                if (tardis.currentEvent != EnumEvent.NONE) {
                    if (this.field_70170_p.func_82737_E() % 80L == 0L) {
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), TSounds.phone, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                } else if (this.field_70170_p.func_82737_E() % 24000L == 0L && this.field_70146_Z.nextInt(4) == 0) {
                    tardis.currentEvent = EnumEvent.DALEK;
                }
            } else {
                tardis.currentEvent = EnumEvent.NONE;
            }
        }
    }

    public void genDalekInvasion(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            TileEntityTardis tardis = (TileEntityTardis)this.field_70170_p.func_175625_s(this.getConsolePos());
            WorldServer ws = this.field_70170_p.func_73046_m().func_71218_a(0);
            BlockPos villagePos = ws.func_72863_F().func_180513_a((World)ws, "Village", tardis.getLocation(), true);
            if (villagePos != null && !villagePos.equals((Object)BlockPos.field_177992_a)) {
                BlockPos pos;
                for (int i = 0; i < 10; ++i) {
                    EntityDalek dalek = new EntityDalek((World)ws);
                    pos = ws.func_175672_r(villagePos.func_177982_a(this.field_70146_Z.nextInt(20) - 10, 64, this.field_70146_Z.nextInt(20) - 10));
                    dalek.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
                    ws.func_72838_d((Entity)dalek);
                }
                for (int c = 0; c < 5; ++c) {
                    EntityCompanion comp = new EntityCompanion((World)ws);
                    pos = ws.func_175672_r(villagePos.func_177982_a(this.field_70146_Z.nextInt(50) - 25, 1, this.field_70146_Z.nextInt(50) - 25));
                    comp.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    ws.func_72838_d((Entity)comp);
                }
                tardis.setDesination(villagePos, 0);
                player.func_146105_b((ITextComponent)new TextComponentString(new TextComponentTranslation("tardis.event.dalek", new Object[0]).func_150254_d() + " " + Helper.formatBlockPos(villagePos)), false);
                tardis.currentEvent = EnumEvent.NONE;
            }
        }
    }

    @Override
    public void init(TileEntityTardis tardis) {
        if (tardis != null) {
            this.func_70105_a(Helper.precentToPixels(3.0f), Helper.precentToPixels(2.0f));
            if (tardis instanceof TileEntityTardis04) {
                this.func_70105_a(Helper.precentToPixels(1.0f), Helper.precentToPixels(2.0f));
            }
            if (tardis instanceof TileEntityTardis05) {
                this.func_70105_a(Helper.precentToPixels(3.0f), Helper.precentToPixels(3.0f));
            }
        }
    }
}

