/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities.hellbent;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tardis.mod.common.IDoor;
import net.tardis.mod.common.entities.IShouldDie;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.sounds.TSounds;

public class EntityHellbentDoor
extends Entity
implements IDoor,
IShouldDie {
    public static final DataParameter<Boolean> IS_OPEN = EntityDataManager.func_187226_a(EntityHellbentDoor.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> OPENING_TICKS = EntityDataManager.func_187226_a(EntityHellbentDoor.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityHellbentDoor(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 3.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_OPEN, (Object)false);
        this.field_70180_af.func_187214_a(OPENING_TICKS, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.func_184212_Q().func_187227_b(IS_OPEN, (Object)compound.func_74767_n("open"));
        this.func_184212_Q().func_187227_b(OPENING_TICKS, (Object)compound.func_74762_e("opening_ticks"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("open", ((Boolean)this.field_70180_af.func_187225_a(IS_OPEN)).booleanValue());
        compound.func_74768_a("opening_ticks", ((Integer)this.field_70180_af.func_187225_a(OPENING_TICKS)).intValue());
    }

    @Override
    public boolean isOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_OPEN);
    }

    @Override
    public void setOpen(boolean b) {
        this.field_70180_af.func_187227_b(IS_OPEN, (Object)b);
        if (this.isOpen()) {
            this.func_184185_a(TSounds.INTERIOR_DOOR_1963, 1.0f, 1.0f);
        }
    }

    public int getOpeningTicks() {
        return (Integer)this.func_184212_Q().func_187225_a(OPENING_TICKS);
    }

    public void setOpeningTicks(int ticks) {
        this.func_184212_Q().func_187227_b(OPENING_TICKS, (Object)ticks);
    }

    public AxisAlignedBB func_70046_E() {
        return this.isOpen() ? null : this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            this.setOpen(!this.isOpen());
        }
        this.field_70170_p.func_184148_a(null, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o(), (double)this.func_180425_c().func_177952_p(), TSounds.INTERIOR_DOOR_1963, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return EnumActionResult.SUCCESS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source != null && source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)new ItemStack(TItems.hellbent_door));
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.isOpen() && this.getOpeningTicks() == 0) {
            this.setOpeningTicks(this.getOpeningTicks() - 1);
        } else if (this.isOpen() && this.getOpeningTicks() < 140) {
            this.setOpeningTicks(this.getOpeningTicks() + 1);
        }
        if (this.getOpeningTicks() == 1 && this.isOpen() || this.getOpeningTicks() != 139 || !this.isOpen()) {
            // empty if block
        }
    }
}

