/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.tardis.mod.common.TDamage;
import net.tardis.mod.common.entities.EntityLaserRay;
import net.tardis.mod.common.items.ItemBase;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.sounds.TSounds;

public class ItemRayGun
extends ItemBase {
    public static final String AMMO_KEY = "ammo";

    public ItemRayGun() {
        this.func_77625_d(1);
    }

    public static void setAmmo(ItemStack stack, int ammo) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(AMMO_KEY, ammo);
    }

    public static int getAmmo(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(AMMO_KEY)) {
            return stack.func_77978_p().func_74762_e(AMMO_KEY);
        }
        return 0;
    }

    public static ItemStack getAmmoInInventory(NonNullList<ItemStack> stacks, Item item) {
        for (ItemStack stack : stacks) {
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack gun = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            ItemStack ammo = ItemRayGun.getAmmoInInventory((NonNullList<ItemStack>)playerIn.field_71071_by.field_70462_a, TItems.power_cell);
            if (!ammo.func_190926_b()) {
                ItemRayGun.setAmmo(gun, ItemRayGun.getAmmo(gun) + ammo.func_190916_E() * 5);
                ammo.func_190918_g(ammo.func_190916_E());
            }
        } else {
            playerIn.func_184598_c(handIn);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)gun);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase livingBase, int timeLeft) {
        if (livingBase instanceof EntityPlayer) {
            EntityPlayer playerIn = (EntityPlayer)livingBase;
            if (ItemRayGun.getAmmo(stack) > 0) {
                if (!worldIn.field_72995_K) {
                    EntityLaserRay entity = new EntityLaserRay(worldIn, (EntityLivingBase)playerIn, 5.0f, TDamage.LASER, new Vec3d(0.0, 1.0, 0.0));
                    entity.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
                    worldIn.func_72838_d((Entity)entity);
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                    ItemRayGun.setAmmo(stack, ItemRayGun.getAmmo(stack) - 1);
                }
                worldIn.func_184133_a(null, playerIn.func_180425_c(), TSounds.dalek_ray, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ItemRayGun.getAmmo(stack) > 0) {
            tooltip.add(new TextComponentTranslation("raygun.ammo", new Object[]{ItemRayGun.getAmmo(stack)}).func_150260_c());
        } else {
            tooltip.add(new TextComponentTranslation("raygun.ammo.none", new Object[0]).func_150254_d());
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

