/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.items;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tardis.mod.client.creativetabs.TardisTabs;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.items.components.ItemComponent;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.PlayerHelper;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class ItemRepairCapsule
extends Item {
    public ItemRepairCapsule() {
        this.func_77637_a(TardisTabs.ITEMS);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            if (ItemRepairCapsule.getComponent(stack) == ItemStack.field_190927_a) {
                int i = 0;
                for (ItemStack inv : playerIn.field_71071_by.field_70462_a) {
                    if (inv.func_77973_b() instanceof ItemComponent) {
                        ItemRepairCapsule.setComponent(stack, inv);
                        playerIn.field_71071_by.func_70304_b(i);
                        break;
                    }
                    ++i;
                }
            } else {
                ItemStack component = ItemRepairCapsule.getComponent(stack);
                if (TardisHelper.hasTardis(playerIn.func_110124_au())) {
                    playerIn.func_184611_a(handIn, ItemStack.field_190927_a);
                    WorldServer server = ((WorldServer)worldIn).func_73046_m().func_71218_a(TDimensions.TARDIS_ID);
                    TileEntity te = server.func_175625_s(TardisHelper.getTardis(playerIn.func_110124_au()));
                    if (te instanceof TileEntityTardis) {
                        TileEntityTardis tardis = (TileEntityTardis)te;
                        for (TardisSystems.BaseSystem system : tardis.systems) {
                            if (system.getRepairItem() != component.func_77973_b()) continue;
                            worldIn.func_184133_a(null, playerIn.func_180425_c(), TSounds.takeoff, SoundCategory.MASTER, 1.0f, 1.0f);
                            system.setHealth((float)(100 - component.func_77952_i()) * 0.01f);
                            break;
                        }
                    }
                } else {
                    PlayerHelper.sendMessage(playerIn, "No TARDIS Found!", true);
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static void setComponent(ItemStack stack, ItemStack component) {
        NBTTagCompound tag = Helper.getStackTag(stack);
        tag.func_74782_a("inv", (NBTBase)component.serializeNBT());
    }

    public static ItemStack getComponent(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("inv")) {
            return new ItemStack(tag.func_74775_l("inv"));
        }
        return ItemStack.field_190927_a;
    }
}

