/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.screwdriver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.tardis.mod.common.screwdriver.IScrew;
import net.tardis.mod.util.common.helpers.PlayerHelper;

@Mod.EventBusSubscriber(modid="tardis")
public class InteractionGeneral
implements IScrew {
    private Method dispense = ReflectionHelper.findMethod(BlockDispenser.class, (String)"dispense", (String)"func_176439_d", (Class[])new Class[]{World.class, BlockPos.class});

    @Override
    public EnumActionResult performAction(World world, EntityPlayer player, EnumHand hand) {
        return EnumActionResult.FAIL;
    }

    @Override
    public EnumActionResult blockInteraction(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        Block block = state.func_177230_c();
        if (block.isWood((IBlockAccess)world, pos) || block.getRegistryName().toString().contains("wood") || state.func_185904_a().equals(Material.field_151575_d)) {
            PlayerHelper.sendMessage(player, "screw.fail.itswood", true);
            return EnumActionResult.FAIL;
        }
        if (block instanceof BlockTNT) {
            BlockTNT tnt = (BlockTNT)block;
            tnt.func_180692_a(world, pos, state.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)), (EntityLivingBase)player);
            world.func_175698_g(pos);
            return EnumActionResult.SUCCESS;
        }
        if (block instanceof BlockTrapDoor) {
            IBlockState newState = state.func_177231_a((IProperty)BlockTrapDoor.field_176283_b);
            this.markUpdate(world, pos, newState);
            if (((Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b)).booleanValue()) {
                int i = state.func_185904_a() == Material.field_151573_f ? 1037 : 1007;
                world.func_180498_a(player, i, pos, 0);
            } else {
                int j = state.func_185904_a() == Material.field_151573_f ? 1036 : 1013;
                world.func_180498_a(player, j, pos, 0);
            }
            return EnumActionResult.SUCCESS;
        }
        if (block instanceof BlockRedstoneLight) {
            if (block == Blocks.field_150379_bu) {
                world.func_180501_a(pos, Blocks.field_150374_bv.func_176223_P(), 2);
                return EnumActionResult.SUCCESS;
            }
            world.func_180501_a(pos, Blocks.field_150379_bu.func_176223_P(), 2);
            return EnumActionResult.SUCCESS;
        }
        if (block instanceof BlockDoor) {
            boolean isTop;
            int meta = block.func_176201_c(state);
            boolean bl = isTop = (meta & 8) != 0;
            if (isTop) {
                IBlockState down = world.func_180495_p(pos.func_177977_b());
                IBlockState newState = down.func_177231_a((IProperty)BlockDoor.field_176519_b);
                this.markUpdate(world, pos.func_177977_b(), newState);
                world.func_180498_a(player, ((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? (state.func_185904_a() == Material.field_151573_f ? 1005 : 1006) : (state.func_185904_a() == Material.field_151573_f ? 1011 : 1012), pos, 0);
            } else {
                IBlockState newState = state.func_177231_a((IProperty)BlockDoor.field_176519_b);
                this.markUpdate(world, pos, newState);
                world.func_180498_a(player, ((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? (state.func_185904_a() == Material.field_151573_f ? 1005 : 1006) : (state.func_185904_a() == Material.field_151573_f ? 1011 : 1012), pos, 0);
            }
            return EnumActionResult.SUCCESS;
        }
        if (block instanceof BlockDispenser) {
            if (!player.func_70093_af()) {
                return EnumActionResult.FAIL;
            }
            try {
                this.dispense.invoke((Object)block, world, pos);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public boolean entityInteraction(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        return false;
    }

    private void markUpdate(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state, 10);
        world.func_175704_b(pos, pos);
    }

    @Override
    public String getName() {
        return "screw.general";
    }

    @Override
    public int getCoolDownAmount() {
        return 50;
    }

    @Override
    public boolean causesCoolDown() {
        return true;
    }

    @Override
    public int energyRequired() {
        return 5;
    }

    @Override
    public String getInfo() {
        return "screwdriver.info.blocks";
    }
}

