/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.systems;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.systems.SystemFlight;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.network.NetworkHandler;
import net.tardis.mod.network.packets.MessageMissControl;

public class SystemStabilizers
extends TardisSystems.BaseSystem {
    private boolean isStabilized = false;
    private int controlsMissed = 0;
    private Random rand = new Random();

    @Override
    public void onUpdate(World world, BlockPos consolePos) {
        if (!world.field_72995_K && world.func_82737_E() % 150L == 0L) {
            TileEntityTardis tardis = (TileEntityTardis)world.func_175625_s(consolePos);
            if (tardis.overrideStabilizers) {
                return;
            }
            if (!this.isStabilized) {
                if (tardis != null && tardis.isInFlight()) {
                    if (tardis.getCourseCorrect() != TileEntityTardis.EnumCourseCorrect.NONE) {
                        ++this.controlsMissed;
                        this.explode(world, consolePos);
                        SystemFlight f = tardis.getSystem(SystemFlight.class);
                        f.setHealth(f.getHealth() - 0.05f);
                    }
                    TileEntityTardis.EnumCourseCorrect newEvent = TileEntityTardis.EnumCourseCorrect.values()[this.rand.nextInt(TileEntityTardis.EnumCourseCorrect.values().length)];
                    tardis.setCourseEvent(newEvent);
                    for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, Block.field_185505_j.func_186670_a(consolePos).func_186662_g(16.0))) {
                        player.func_146105_b((ITextComponent)new TextComponentString(newEvent.getTranslation().func_150254_d()), true);
                    }
                } else {
                    this.controlsMissed = 0;
                    if (tardis != null) {
                        tardis.setCourseEvent(TileEntityTardis.EnumCourseCorrect.NONE);
                    }
                }
            } else {
                this.controlsMissed = 0;
                if (tardis != null) {
                    tardis.setCourseEvent(TileEntityTardis.EnumCourseCorrect.NONE);
                }
            }
            if (this.getHealth() <= 0.0f) {
                this.isStabilized = false;
            }
        }
    }

    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
            NetworkHandler.NETWORK.sendToAllAround((IMessage)new MessageMissControl(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 25.0));
            TileEntityTardis tardis = (TileEntityTardis)world.func_175625_s(pos);
            tardis.setDesination(tardis.getDestination().func_177982_a(this.rand.nextInt(20) - 10, this.rand.nextInt(20) - 10, this.rand.nextInt(20) - 10), tardis.getTargetDim());
        }
    }

    @Override
    public void damage() {
    }

    @Override
    public Item getRepairItem() {
        return TItems.stabilizers;
    }

    @Override
    public String getNameKey() {
        return "system.tardis.stabilizers";
    }

    @Override
    public String getUsage() {
        return "Without this system, you will not be able to pilot your TARDIS without console dancing";
    }

    @Override
    public void wear() {
        if (this.isOn()) {
            this.setHealth(this.getHealth() - 0.01f);
        }
    }

    @Override
    public boolean shouldStopFlight() {
        return false;
    }

    public boolean isOn() {
        return this.isStabilized;
    }

    public void setOn(boolean on) {
        this.isStabilized = on;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.isStabilized = tag.func_74767_n("stab");
        this.controlsMissed = tag.func_74762_e("cont");
    }

    @Override
    public NBTTagCompound writetoNBT(NBTTagCompound tag) {
        tag.func_74757_a("stab", this.isStabilized);
        tag.func_74768_a("cont", this.controlsMissed);
        return super.writetoNBT(tag);
    }
}

