/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityTardis;

public class MessageDamageSystem
implements IMessage {
    private BlockPos pos = BlockPos.field_177992_a;
    private String system = "";

    public MessageDamageSystem() {
    }

    public MessageDamageSystem(BlockPos pos, String id) {
        this.pos = pos;
        this.system = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.system = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.system);
    }

    public static class Helper
    implements IMessageHandler<MessageDamageSystem, IMessage> {
        public IMessage onMessage(final MessageDamageSystem message, final MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TardisSystems.BaseSystem sys;
                    WorldServer ws = ctx.getServerHandler().field_147369_b.func_184102_h().func_71218_a(TDimensions.TARDIS_ID);
                    TileEntityTardis tardis = (TileEntityTardis)ws.func_175625_s(message.pos);
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    if (tardis != null && (sys = (TardisSystems.BaseSystem)tardis.getSystem(TardisSystems.createFromName(message.system).getClass())) != null) {
                        if (sys.getHealth() > 0.0f) {
                            ItemStack stack = new ItemStack(sys.getRepairItem());
                            stack.func_77964_b((int)(100.0f - sys.getHealth() * 100.0f));
                            InventoryHelper.func_180173_a((World)ws, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)stack);
                        }
                        sys.setHealth(0.0f);
                    }
                }
            });
            return null;
        }
    }
}

