/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.PlayerHelper;

public class MessageTelepathicCircuit
implements IMessage {
    public BlockPos pos = BlockPos.field_177992_a;
    public String name = "";

    public MessageTelepathicCircuit() {
    }

    public MessageTelepathicCircuit(BlockPos tardisPos, String name) {
        this.pos = tardisPos.func_185334_h();
        if (name != null) {
            this.name = name;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeLong(this.pos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<MessageTelepathicCircuit, IMessage> {
        public IMessage onMessage(MessageTelepathicCircuit message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> {
                boolean managed = false;
                MinecraftServer server = ctx.getServerHandler().field_147369_b.func_184102_h();
                WorldServer ws = DimensionManager.getWorld((int)TDimensions.TARDIS_ID);
                EntityPlayerMP player = server.func_184103_al().func_152612_a(message.name.trim().toLowerCase());
                TileEntity te = ws.func_175625_s(message.pos);
                if (te != null && te instanceof TileEntityTardis) {
                    TileEntityTardis tardis = (TileEntityTardis)ws.func_175625_s(message.pos);
                    WorldServer locationWorld = DimensionManager.getWorld((int)tardis.getTargetDim());
                    if (player != null && !player.field_71071_by.func_70431_c(new ItemStack(TItems.biodampener))) {
                        tardis.setDesination(player.func_180425_c(), player.field_71093_bK);
                        tardis.startFlight();
                        managed = true;
                    } else {
                        Biome b = Helper.findBiomeByName(message.name.toLowerCase().trim());
                        if (b != null) {
                            ArrayList<Biome> biomes = new ArrayList<Biome>();
                            biomes.add(b);
                            BlockPos biomePos = locationWorld.func_72959_q().func_180630_a(tardis.getLocation().func_177958_n(), tardis.getLocation().func_177952_p(), 1000, biomes, new Random());
                            if (biomePos != null && !biomePos.equals((Object)BlockPos.field_177992_a)) {
                                biomePos.func_177982_a(0, locationWorld.func_181545_F(), 0);
                                tardis.setDesination(biomePos, tardis.getTargetDim());
                                tardis.startFlight();
                                managed = true;
                            } else {
                                PlayerHelper.sendMessage((EntityPlayer)ctx.getServerHandler().field_147369_b, (ITextComponent)new TextComponentString("Biome not found in range!"), true);
                                managed = true;
                            }
                        } else {
                            Random rand = ctx.getServerHandler().field_147369_b.field_70170_p.field_73012_v;
                            BlockPos structurePos = locationWorld.func_190528_a(message.name.trim(), tardis.getLocation(), true);
                            if (structurePos != null && !BlockPos.field_177992_a.equals((Object)structurePos)) {
                                tardis.setDesination(structurePos.func_177982_a(rand.nextInt(6) - 3, 0, rand.nextInt(6) - 3), tardis.getTargetDim());
                                tardis.startFlight();
                                managed = true;
                            }
                        }
                    }
                    if (!managed) {
                        PlayerHelper.sendMessage((EntityPlayer)ctx.getServerHandler().field_147369_b, (ITextComponent)new TextComponentTranslation("tardis.message.tc_notfound", new Object[]{TextFormatting.GOLD + TextFormatting.BOLD.toString() + message.name.trim(), TextFormatting.GOLD + TextFormatting.BOLD.toString() + Helper.formatDimensionName(DimensionManager.createProviderFor((int)tardis.dimension).func_186058_p().func_186065_b())}), true);
                        tardis.func_145831_w().func_184133_a(null, tardis.func_174877_v(), TSounds.engine_stutter, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            });
            return null;
        }
    }
}

