/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.SpaceTimeCoord;

public class MessageWaypointSave
implements IMessage {
    BlockPos pos = BlockPos.field_177992_a;
    SpaceTimeCoord coord = SpaceTimeCoord.ORIGIN;

    public MessageWaypointSave() {
    }

    public MessageWaypointSave(BlockPos pos, SpaceTimeCoord coord) {
        this.pos = pos.func_185334_h();
        this.coord = coord;
    }

    public void fromBytes(ByteBuf buf) {
        this.coord = SpaceTimeCoord.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.coord.writeToNBT(new NBTTagCompound()));
        buf.writeLong(this.pos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<MessageWaypointSave, IMessage> {
        public IMessage onMessage(final MessageWaypointSave message, final MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q().func_73046_m().func_71218_a(TDimensions.TARDIS_ID);
                    TileEntityTardis tardis = (TileEntityTardis)world.func_175625_s(message.pos);
                    if (tardis != null) {
                        for (int i = 0; i < tardis.saveCoords.size(); ++i) {
                            if (!SpaceTimeCoord.ORIGIN.equals(tardis.saveCoords.get(i))) continue;
                            tardis.saveCoords.set(i, (Object)message.coord);
                            break;
                        }
                    } else {
                        System.out.println("No TARDIS, " + message.pos);
                    }
                }
            });
            return null;
        }
    }
}

