/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.util.common.helpers;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.tardis.mod.api.dimensions.IBlockedDimension;
import net.tardis.mod.client.worldshell.WorldShell;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.config.TardisConfig;
import net.tardis.mod.util.TardisTeleporter;

public class Helper {
    public static Random rand = new Random();

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz, Random random) {
        int x = random.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    public static void transferToOwnedTardis(EntityPlayerMP player, WorldServer world, BlockPos pos) {
    }

    public static String formatBlockPos(BlockPos pos) {
        if (pos == null || pos.equals((Object)BlockPos.field_177992_a)) {
            return "None";
        }
        return pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
    }

    public static void transferToWorld(EntityPlayerMP player, WorldServer world, BlockPos pos, int dim) {
        world.func_73046_m().func_184103_al().transferPlayerToDimension(player, dim, (ITeleporter)new TardisTeleporter(new BlockPos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5)));
    }

    public static Vec3d convertToPixels(Vec3d vec) {
        return new Vec3d(vec.field_72450_a / 16.0, vec.field_72448_b / 16.0, vec.field_72449_c / 16.0);
    }

    public static Vec3d convertToPixels(double x, double y, double z) {
        return new Vec3d(x / 16.0, y / 16.0, z / 16.0);
    }

    public static BlockPos getLowestBlock(World world, BlockPos pos) {
        pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        for (int i = 0; i < 256; ++i) {
            if (Helper.isStateOverwritable(world.func_180495_p(pos)) && Helper.isStateOverwritable(world.func_180495_p(pos.func_177984_a()))) {
                return pos;
            }
            pos = pos.func_177984_a();
        }
        return null;
    }

    public static boolean isStateOverwritable(IBlockState state) {
        return state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151579_a || state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151586_h || state.func_185904_a() == Material.field_151593_r || state.func_185904_a().func_76224_d() || state.func_185904_a().func_76222_j();
    }

    public static double clamp(double f, double f1) {
        return f > f1 ? f1 : f;
    }

    public static AxisAlignedBB createBB(BlockPos pos, double i) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)).func_186662_g(i);
    }

    public static boolean isSafe(World world, BlockPos pos, EnumFacing facing) {
        return Helper.isStateOverwritable(world.func_180495_p(pos)) && Helper.isStateOverwritable(world.func_180495_p(pos.func_177984_a())) && !Helper.isStateOverwritable(world.func_180495_p(pos.func_177977_b()));
    }

    public static boolean isDimensionBlocked(int id) {
        if (id == TDimensions.TARDIS_ID) {
            return true;
        }
        if (DimensionManager.createProviderFor((int)id) instanceof IBlockedDimension) {
            return true;
        }
        boolean isW = TardisConfig.Dimensions.USE_WHITELIST;
        for (int i : TardisConfig.Dimensions.bDims) {
            if (isW) {
                if (id != i) continue;
                return false;
            }
            if (id != i) continue;
            return true;
        }
        return isW;
    }

    public static float getAngleFromFacing(EnumFacing facing) {
        float angle = 0.0f;
        if (facing.equals((Object)EnumFacing.EAST)) {
            angle = 90.0f;
        }
        if (facing.equals((Object)EnumFacing.SOUTH)) {
            angle = 180.0f;
        }
        if (facing.equals((Object)EnumFacing.WEST)) {
            angle = 270.0f;
        }
        return angle;
    }

    public static Rotation getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static float get180Rot(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180.0f;
            }
            case EAST: {
                return -90.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
        }
        return 90.0f;
    }

    public static boolean isIntInRange(int min, int max, int num) {
        return num < max && num > min;
    }

    public static int getSlotForItem(EntityPlayer player, Item item) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (player.field_71071_by.func_70301_a(i).func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static Biome findBiomeByName(String string) {
        List biomes = ForgeRegistries.BIOMES.getValues();
        for (Biome biome : biomes) {
            if (!biome.field_76791_y.trim().toLowerCase().equals(string)) continue;
            return biome;
        }
        return null;
    }

    public static Vec3d blockPosToVec3d(Vec3i pos) {
        return new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static BlockPos getSafePosLower(BlockPos pos, World world, EnumFacing facing) {
        for (int y = pos.func_177956_o(); y > 0; --y) {
            BlockPos lPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            if (!Helper.isSafe(world, lPos, facing)) continue;
            return lPos;
        }
        return BlockPos.field_177992_a;
    }

    public static BlockPos getSafeHigherPos(World world, BlockPos pos, EnumFacing facing) {
        for (int y = pos.func_177956_o(); y < world.func_72800_K(); ++y) {
            BlockPos lPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            if (!Helper.isSafe(world, lPos, facing)) continue;
            return lPos;
        }
        return BlockPos.field_177992_a;
    }

    public static float precentToPixels(float f) {
        return f / 16.0f;
    }

    public static String formatDimensionName(String name) {
        if (name == null) {
            return "UNKNOWN!";
        }
        name = name.replace("_", " ");
        char[] nameChars = name.toCharArray();
        for (int index = 0; index < nameChars.length; ++index) {
            if (nameChars[index] != ' ' || index + 1 >= nameChars.length) continue;
            char c = nameChars[index + 1];
            nameChars[index + 1] = Character.toUpperCase(c);
        }
        nameChars[0] = Character.toUpperCase(nameChars[0]);
        return new String(nameChars);
    }

    public static NBTTagCompound getStackTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static BlockPos scaleBP(BlockPos dist, double i) {
        return new BlockPos((double)dist.func_177958_n() * i, (double)dist.func_177956_o() * i, (double)dist.func_177952_p() * i);
    }

    public static TileEntityTardis getTardis(TileEntity te) {
        return te != null && te instanceof TileEntityTardis ? (TileEntityTardis)te : null;
    }

    public static boolean isThisBlockBehindTheWorldBorder(BlockPos pos, int dim) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim).func_175723_af().func_177746_a(pos);
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static int getLight(World world, BlockPos pos) {
        int light = 0;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int newLight = world.func_175721_c(pos.func_177972_a(face), true);
            if (newLight <= light) continue;
            light = newLight;
        }
        return light;
    }

    public static int getDaylight(World world, BlockPos pos) {
        int light = 0;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int newLight = world.func_175642_b(EnumSkyBlock.SKY, pos);
            if (newLight <= light) continue;
            light = newLight;
        }
        return light;
    }

    public static boolean areWorldShellsEqual(WorldShell shell, WorldShell shell1) {
        if (!shell.getOffset().equals((Object)shell1.getOffset())) {
            return false;
        }
        if (shell.blockMap.size() != shell1.blockMap.size()) {
            return false;
        }
        for (BlockPos pos : shell.blockMap.keySet()) {
            if (shell.blockMap.get(pos).equals(shell1.blockMap.get(pos))) continue;
            return false;
        }
        return true;
    }

    public static boolean canRenderInBOTI(IBlockState state) {
        for (String blocked : TardisConfig.BOTI.modids) {
            if (state.func_177230_c().getRegistryName().toString().equals(blocked)) {
                return false;
            }
            if (!blocked.endsWith("*")) continue;
            String modid = blocked.substring(0, blocked.indexOf(58));
            if (!state.func_177230_c().getRegistryName().func_110624_b().equals(modid)) continue;
            return false;
        }
        return true;
    }
}

