/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.util.common.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.items.ItemKey;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.handlers.TEventHandler;
import net.tardis.mod.network.NetworkHandler;
import net.tardis.mod.network.packets.MessageSyncTardises;

public class TardisHelper {
    public static final int TARDIS_SIZE = 16;
    public static Map<String, BlockPos> tardisOwners = new HashMap<String, BlockPos>();

    public static boolean isConsoleChunk(Chunk c) {
        return c.field_76635_g % 16 == 0 && c.field_76647_h % 16 == 0;
    }

    public static boolean hasTardis(UUID id) {
        return tardisOwners.containsKey(id.toString());
    }

    public static BlockPos getTardis(UUID id) {
        if (TardisHelper.hasTardis(id)) {
            return tardisOwners.get(id.toString());
        }
        return TardisHelper.addTardis(id);
    }

    public static BlockPos addTardis(UUID id) {
        BlockPos pos = TardisHelper.getNextFree();
        tardisOwners.put(id.toString(), pos.func_185334_h());
        if (TEventHandler.data != null) {
            TEventHandler.data.func_76185_a();
        }
        return pos;
    }

    public static BlockPos getLastPos() {
        int size = tardisOwners.size();
        if (size > 0) {
            BlockPos last = BlockPos.field_177992_a;
            for (BlockPos pos : tardisOwners.values().toArray(new BlockPos[0])) {
                if (pos.func_177958_n() <= last.func_177958_n() || pos.func_177952_p() <= last.func_177952_p()) continue;
                last = pos;
            }
            return last;
        }
        return new BlockPos(8, 128, 8);
    }

    public static BlockPos getNextFree() {
        return TardisHelper.getLastPos().func_177982_a(256, 0, 256);
    }

    public static boolean hasValidKey(EntityLivingBase player, BlockPos cPos) {
        ItemStack stack = player.func_184614_ca();
        ItemStack otherStack = player.func_184592_cb();
        if (stack.func_77973_b() instanceof ItemKey) {
            BlockPos pos = ItemKey.getPos(stack);
            return pos != null && pos.equals((Object)cPos);
        }
        if (otherStack.func_77973_b() instanceof ItemKey) {
            BlockPos pos = ItemKey.getPos(otherStack);
            return pos != null && pos.equals((Object)cPos);
        }
        return false;
    }

    public static BlockPos getTardisForPosition(Vec3i vec) {
        for (BlockPos pos : tardisOwners.values()) {
            if (!(pos.func_185332_f(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p()) < 120.0)) continue;
            return pos;
        }
        return BlockPos.field_177992_a;
    }

    public static Map<String, BlockPos> getOwnerList() {
        return tardisOwners;
    }

    public static TileEntityTardis getConsole(BlockPos pos) {
        WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(TDimensions.TARDIS_ID);
        if (worldServer.func_175625_s(pos) instanceof TileEntityTardis) {
            return (TileEntityTardis)worldServer.func_175625_s(pos);
        }
        return null;
    }

    @Mod.EventBusSubscriber(modid="tardis")
    public static class Events {
        @SubscribeEvent
        public static void sync(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving().field_70170_p.func_72820_D() % 200L == 0L && !event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer) {
                NetworkHandler.NETWORK.sendTo((IMessage)new MessageSyncTardises(), (EntityPlayerMP)event.getEntityLiving());
            }
        }
    }
}

