/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.waila;

import buildcraft.compat.CompatUtils;
import buildcraft.compat.module.waila.BaseWailaDataProvider;
import buildcraft.compat.module.waila.HWYLAPlugin;
import buildcraft.lib.tile.craft.IAutoCraft;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

class AutoCraftDataProvider
extends BaseWailaDataProvider {
    AutoCraftDataProvider() {
    }

    @Override
    @Nonnull
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile = accessor.getTileEntity();
        if (tile instanceof IAutoCraft) {
            NBTTagCompound nbt = accessor.getNBTData();
            if (nbt.func_150297_b("recipe_result", 10)) {
                ItemStack result = new ItemStack(nbt.func_74775_l("recipe_result"));
                currentTip.add(TextFormatting.WHITE + "Making: " + SpecialChars.WailaSplitter + HWYLAPlugin.getItemStackString(result));
                if (nbt.func_150297_b("recipe_inputs", 9)) {
                    NBTTagList list = nbt.func_150295_c("recipe_inputs", 10);
                    StringBuilder inputs = new StringBuilder(TextFormatting.WHITE + "From: " + SpecialChars.WailaSplitter);
                    for (int index = 0; index < list.func_74745_c(); ++index) {
                        NBTTagCompound compound = (NBTTagCompound)NBTTagCompound.class.cast(list.func_179238_g(index));
                        inputs.append(HWYLAPlugin.getItemStackString(new ItemStack(compound)));
                    }
                    currentTip.add(inputs.toString());
                }
            } else {
                currentTip.add(TextFormatting.GRAY + "No recipe");
            }
        } else {
            currentTip.add(TextFormatting.RED + "{wrong tile entity}");
        }
        return currentTip;
    }

    @Override
    @Nonnull
    @Optional.Method(modid="waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        IAutoCraft auto;
        ItemStack output;
        NBTTagCompound nbt = super.getNBTData(player, te, tag, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IAutoCraft && !(output = (auto = (IAutoCraft)IAutoCraft.class.cast(tile)).getCurrentRecipeOutput()).func_190926_b()) {
            nbt.func_74782_a("recipe_result", (NBTBase)output.serializeNBT());
            List<ItemStack> stacks = CompatUtils.compactInventory(auto.getInvBlueprint());
            NBTTagList list = new NBTTagList();
            for (int index = 0; index < stacks.size(); ++index) {
                list.func_74742_a((NBTBase)stacks.get(index).serializeNBT());
            }
            nbt.func_74782_a("recipe_inputs", (NBTBase)list);
        }
        return nbt;
    }
}

