/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.sprite;

import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.client.reload.IReloadable;
import buildcraft.lib.client.reload.ReloadManager;
import buildcraft.lib.client.reload.ReloadSource;
import buildcraft.lib.client.reload.ReloadUtil;
import buildcraft.lib.client.reload.SourceType;
import buildcraft.lib.client.sprite.AtlasSpriteSwappable;
import buildcraft.lib.misc.SpriteUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntSupplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class AtlasSpriteVariants
extends AtlasSpriteSwappable
implements IReloadable {
    public static final IVariantType VARIANT_COLOUR_BLIND = loc -> ImmutableList.of((Object)loc, (Object)new ResourceLocation(loc.func_110624_b(), loc.func_110623_a() + "_cb"));
    public static final IntSupplier INDEX_COLOUR_BLIND = () -> BCLibConfig.colourBlindMode ? 1 : 0;
    private final List<ResourceLocation> variantNames;
    private final IntSupplier currentIndexFunction;
    private final TextureAtlasSprite[] variants;
    private int currentIndex = -1;

    public AtlasSpriteVariants(List<ResourceLocation> variantNames, IntSupplier currentIndexFunction) {
        super(variantNames.get(0).toString());
        if (variantNames.isEmpty()) {
            throw new IllegalArgumentException("Not enough names!");
        }
        this.variantNames = AtlasSpriteVariants.processNames(variantNames);
        this.variants = new TextureAtlasSprite[variantNames.size()];
        this.currentIndexFunction = currentIndexFunction;
    }

    public AtlasSpriteVariants(ResourceLocation baseName, IVariantType variants, IntSupplier currentIndex) {
        this(variants.getAllPossibleVariants(baseName), currentIndex);
    }

    private static List<ResourceLocation> processNames(List<ResourceLocation> names) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ResourceLocation loc : names) {
            builder.add((Object)SpriteUtil.transformLocation(loc));
        }
        return builder.build();
    }

    public static TextureAtlasSprite createForConfig(ResourceLocation baseName) {
        if (baseName.func_110624_b().startsWith("minecraft")) {
            return AtlasSpriteVariants.func_176604_a((ResourceLocation)baseName);
        }
        if (BCLibConfig.useSwappableSprites) {
            AtlasSpriteVariants sprite = new AtlasSpriteVariants(baseName, VARIANT_COLOUR_BLIND, INDEX_COLOUR_BLIND);
            ReloadSource to = new ReloadSource(SpriteUtil.transformLocation(baseName), SourceType.SPRITE);
            ReloadManager manager = ReloadManager.INSTANCE;
            manager.addDependency(ReloadManager.CONFIG_COLOUR_BLIND, sprite, to);
            manager.addDependency(new ReloadSource(sprite.variantNames.get(0), SourceType.FILE), sprite, to);
            manager.addDependency(new ReloadSource(sprite.variantNames.get(1), SourceType.FILE), sprite, to);
            return sprite;
        }
        int index = INDEX_COLOUR_BLIND.getAsInt();
        ResourceLocation location = VARIANT_COLOUR_BLIND.getAllPossibleVariants(baseName).get(index);
        return AtlasSpriteVariants.func_176604_a((ResourceLocation)location);
    }

    @Override
    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        for (int i = 0; i < this.variantNames.size(); ++i) {
            ResourceLocation loc = this.variantNames.get(i);
            this.variants[i] = AtlasSpriteVariants.loadSprite(manager, this.func_94215_i(), loc, i == 0);
        }
        this.currentIndex = -1;
        this.reload((Set<ReloadSource>)ImmutableSet.of());
        return false;
    }

    @Override
    public boolean reload(Set<ReloadSource> changed) {
        TextureAtlasSprite sprite;
        if (!changed.isEmpty()) {
            for (int i = 0; i < this.variantNames.size(); ++i) {
                TextureAtlasSprite s;
                ResourceLocation loc = this.variantNames.get(i);
                if (!ReloadUtil.getSourceTypesFor(changed, loc).contains((Object)SourceType.FILE) || (s = AtlasSpriteVariants.loadSprite(this.func_94215_i(), loc, i == 0)) == null) continue;
                if (s.func_94211_a() == this.field_130223_c && s.func_94216_b() == this.field_130224_d) {
                    this.variants[i] = s;
                    continue;
                }
                BCLog.logger.warn("Unable to reload " + loc + " as the new sprite was a different width and height!");
            }
        }
        this.currentIndex = this.currentIndexFunction.getAsInt();
        if (this.currentIndex < 0 || this.currentIndex >= this.variants.length) {
            this.currentIndex = 0;
        }
        if ((sprite = this.variants[this.currentIndex]) == null) {
            sprite = this.variants[0];
            this.currentIndex = 0;
        }
        return this.swapWith(sprite);
    }

    public static interface IVariantType {
        public List<ResourceLocation> getAllPossibleVariants(ResourceLocation var1);
    }
}

