/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.pos;

import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.pos.PositionAbsolute;

public class PositionOffset
implements IGuiPosition {
    public final IGuiPosition parent;
    public final double xOffset;
    public final double yOffset;

    private PositionOffset(IGuiPosition parent, double xOffset, double yOffset) {
        this.parent = parent;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public static IGuiPosition createOffset(IGuiPosition from, double x, double y) {
        if (from == null) {
            return new PositionAbsolute(x, y);
        }
        if (from instanceof PositionOffset) {
            PositionOffset parent = (PositionOffset)from;
            double oX = x + parent.xOffset;
            double oY = y + parent.yOffset;
            return parent.parent.offset(oX, oY);
        }
        return new PositionOffset(from, x, y);
    }

    @Override
    public double getX() {
        return this.parent.getX() + this.xOffset;
    }

    @Override
    public double getY() {
        return this.parent.getY() + this.yOffset;
    }

    @Override
    public IGuiPosition offset(double x, double y) {
        return new PositionOffset(this.parent, x + this.xOffset, y + this.yOffset);
    }

    @Override
    public IGuiPosition offset(IGuiPosition by) {
        if (by instanceof PositionOffset) {
            PositionOffset other = (PositionOffset)by;
            return new PositionOffset(this.parent.offset(other.parent), this.xOffset + other.xOffset, this.yOffset + other.yOffset);
        }
        return IGuiPosition.super.offset(by);
    }
}

