/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.guide;

import buildcraft.api.BCModules;
import buildcraft.lib.guide.GuideBook;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.ModUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class GuideContentsData {
    @Nullable
    public final GuideBook book;
    public final List<String> loadedMods = new ArrayList<String>();
    public final List<String> loadedOther = new ArrayList<String>();

    public GuideContentsData(@Nullable GuideBook book) {
        this.book = book;
    }

    public void generate(Set<String> domains) {
        this.loadedMods.clear();
        this.loadedOther.clear();
        EnumSet<BCModules> bcmods = EnumSet.noneOf(BCModules.class);
        for (String domain : domains) {
            if (domain == null) {
                throw new IllegalArgumentException("Was given a null domain!");
            }
            BCModules bcMod = BCModules.getBcMod(domain);
            if (bcMod != null) {
                bcmods.add(bcMod);
                continue;
            }
            String name = ModUtil.getNameOfMod(domain);
            if (name != null) {
                this.loadedMods.add(name);
                continue;
            }
            this.loadedOther.add(LocaleUtil.localize(domain + ".compat.buildcraft.guide.domain_name"));
        }
        Collections.sort(this.loadedMods);
        Collections.sort(this.loadedOther);
        switch (bcmods.size()) {
            case 0: {
                return;
            }
            case 6: {
                if (this.loadedMods.contains(BCModules.COMPAT.getModId())) break;
                this.loadedMods.add(0, "BuildCraft (main)");
                return;
            }
            case 7: {
                this.loadedMods.add(0, "BuildCraft (all)");
                return;
            }
        }
        ArrayList<String> bcModNames = new ArrayList<String>(6);
        if (bcmods.remove(BCModules.LIB)) {
            bcModNames.add("BuildCraft Lib");
        }
        if (bcmods.remove(BCModules.CORE)) {
            bcModNames.add("BuildCraft Core");
        }
        for (BCModules mod : bcmods) {
            bcModNames.add("BuildCraft " + mod.camelCaseName);
        }
        this.loadedMods.addAll(0, bcModNames);
    }
}

