/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.item;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.transport.IItemPluggable;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.SoundUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class ItemPluggableSimple
extends ItemBC_Neptune
implements IItemPluggable {
    private static final IPlacementPredicate ALWAYS_CAN = (item, h, s) -> true;
    public static final IPlacementPredicate PIPE_BEHAVIOUR_ACCEPTS_RS_POWER = (item, pipeHolder, side) -> {
        IPipe pipe = pipeHolder.getPipe();
        if (pipe != null) {
            return pipe.getBehaviour().getCapability(MjAPI.CAP_REDSTONE_RECEIVER, side) != null;
        }
        return false;
    };
    private final PluggableDefinition definition;
    private final IPlacementPredicate canPlace;
    private final PluggableDefinition.IPluggableCreator creator;

    public ItemPluggableSimple(String id, PluggableDefinition definition, PluggableDefinition.IPluggableCreator creator, @Nullable IPlacementPredicate canPlace) {
        super(id);
        this.definition = definition;
        this.creator = creator;
        if (creator == null) {
            throw new NullPointerException("Creator was null!");
        }
        this.canPlace = canPlace == null ? ALWAYS_CAN : canPlace;
    }

    public ItemPluggableSimple(String id, PluggableDefinition definition, @Nullable IPlacementPredicate canPlace) {
        this(id, definition, definition.creator, canPlace);
    }

    public ItemPluggableSimple(String id, PluggableDefinition definition, @Nonnull PluggableDefinition.IPluggableCreator creator) {
        this(id, definition, creator, null);
    }

    public ItemPluggableSimple(String id, PluggableDefinition definition) {
        this(id, definition, definition.creator, null);
    }

    @Override
    public PipePluggable onPlace(@Nonnull ItemStack stack, IPipeHolder holder, EnumFacing side, EntityPlayer player, EnumHand hand) {
        if (!this.canPlace.canPlace(stack, holder, side)) {
            return null;
        }
        SoundUtil.playBlockPlace(holder.getPipeWorld(), holder.getPipePos());
        return this.creator.createSimplePluggable(this.definition, holder, side);
    }

    @FunctionalInterface
    public static interface IPlacementPredicate {
        public boolean canPlace(ItemStack var1, IPipeHolder var2, EnumFacing var3);
    }
}

