/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.list;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.oredict.OreDictionary;

public final class ListOreDictionaryCache {
    public static final ListOreDictionaryCache INSTANCE = new ListOreDictionaryCache();
    private static final String[] TYPE_KEYWORDS = new String[]{"Tiny", "Dense", "Small"};
    private final Map<String, Set<Integer>> namingCache = new HashMap<String, Set<Integer>>();
    private final Set<String> registeredNames = new HashSet<String>();

    private ListOreDictionaryCache() {
    }

    public Set<Integer> getListOfPartialMatches(String part) {
        return this.namingCache.get(part);
    }

    private void addToNamingCache(String s, int id) {
        if (s == null) {
            return;
        }
        Set<Integer> ll = this.namingCache.get(s);
        if (ll == null) {
            ll = new HashSet<Integer>();
            ll.add(id);
            this.namingCache.put(s, ll);
        } else {
            ll.add(id);
        }
    }

    public static String getType(String name) {
        int splitLocation;
        for (splitLocation = name.length() - 1; splitLocation >= 0 && !Character.isUpperCase(name.codePointAt(splitLocation)); --splitLocation) {
        }
        return splitLocation >= 0 ? name.substring(0, splitLocation) : name;
    }

    public static String getMaterial(String name) {
        int splitLocation = 0;
        String t = null;
        while (splitLocation < name.length()) {
            if (!Character.isUpperCase(name.codePointAt(splitLocation))) {
                ++splitLocation;
                continue;
            }
            t = name.substring(splitLocation);
            for (String s : TYPE_KEYWORDS) {
                if (!t.startsWith(s)) continue;
                t = null;
                break;
            }
            if (t != null) break;
            ++splitLocation;
        }
        return splitLocation < name.length() ? t : null;
    }

    public void registerName(String name) {
        if (this.registeredNames.contains(name)) {
            return;
        }
        int oreID = OreDictionary.getOreID((String)name);
        this.addToNamingCache(ListOreDictionaryCache.getType(name), oreID);
        this.addToNamingCache(ListOreDictionaryCache.getMaterial(name), oreID);
        this.registeredNames.add(name);
    }
}

