/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.marker;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.marker.MarkerConnection;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.MessageMarker;
import buildcraft.lib.tile.TileMarker;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MarkerSubCache<C extends MarkerConnection<C>> {
    public static final boolean DEBUG_FULL = BCDebugging.shouldDebugComplex("lib.marker.full");
    public final int cacheId;
    public final int dimensionId;
    public final boolean isServer;
    private final Map<BlockPos, C> posToConnection = new ConcurrentHashMap<BlockPos, C>();
    private final Map<C, Set<BlockPos>> connectionToPos = new ConcurrentHashMap<C, Set<BlockPos>>();
    private final Map<BlockPos, Optional<TileMarker<C>>> tileCache = new ConcurrentHashMap<BlockPos, Optional<TileMarker<C>>>();

    public MarkerSubCache(World world, int cacheId) {
        this.isServer = !world.field_72995_K;
        this.dimensionId = world.field_73011_w.getDimension();
        this.cacheId = cacheId;
    }

    public void onPlayerJoinWorld(EntityPlayerMP player) {
        if (this.isServer) {
            if (!this.tileCache.isEmpty()) {
                MessageMarker message = new MessageMarker();
                message.add = true;
                message.connection = false;
                message.cacheId = this.cacheId;
                message.positions.addAll(this.tileCache.keySet());
                MessageManager.sendTo(message, player);
            }
            for (MarkerConnection connection : this.connectionToPos.keySet()) {
                MessageMarker message = new MessageMarker();
                message.add = true;
                message.connection = true;
                message.cacheId = this.cacheId;
                message.positions.addAll(connection.getMarkerPositions());
                MessageManager.sendTo(message, player);
            }
        }
    }

    public boolean hasLoadedOrUnloadedMarker(BlockPos pos) {
        return this.tileCache.containsKey(pos);
    }

    @Nullable
    public TileMarker<C> getMarker(BlockPos pos) {
        Optional<TileMarker<C>> op = this.tileCache.get(pos);
        if (op == null) {
            return null;
        }
        return op.orElse(null);
    }

    public void loadMarker(BlockPos pos, @Nullable TileMarker<C> marker) {
        boolean did = this.tileCache.containsKey(pos);
        this.tileCache.put(pos, Optional.ofNullable(marker));
        if (DEBUG_FULL) {
            BCLog.logger.info("[lib.marker.full] Set a marker at " + pos + " as " + marker);
        }
        if (this.isServer && !did) {
            MessageMarker message = new MessageMarker();
            message.add = true;
            message.connection = false;
            message.multiple = false;
            message.cacheId = this.cacheId;
            message.count = 1;
            message.positions.add(pos);
            MessageManager.sendToDimension(message, this.dimensionId);
        }
    }

    public void unloadMarker(BlockPos pos) {
        this.loadMarker(pos, null);
    }

    public void removeMarker(BlockPos pos) {
        if (DEBUG_FULL) {
            BCLog.logger.info("[lib.marker.full] Removed a marker at " + pos);
        }
        this.tileCache.remove(pos);
        C connection = this.getConnection(pos);
        if (connection != null) {
            ((MarkerConnection)connection).removeMarker(pos);
            this.refreshConnection(connection);
        }
        if (this.isServer) {
            MessageMarker message = new MessageMarker();
            message.add = false;
            message.connection = false;
            message.multiple = false;
            message.cacheId = this.cacheId;
            message.count = 1;
            message.positions.add(pos);
            MessageManager.sendToDimension(message, this.dimensionId);
        }
    }

    public ImmutableList<BlockPos> getAllMarkers() {
        return ImmutableList.copyOf(this.tileCache.keySet());
    }

    @Nullable
    public C getConnection(BlockPos pos) {
        return (C)((MarkerConnection)this.posToConnection.get(pos));
    }

    public void destroyConnection(@Nullable C connection) {
        if (connection == null) {
            return;
        }
        Set<BlockPos> set = this.connectionToPos.remove(connection);
        if (set != null) {
            this.deinitConnection(set);
        }
        if (DEBUG_FULL) {
            this.validateAllConnections();
        }
    }

    public void addConnection(@Nonnull C connection) {
        HashSet<BlockPos> lastSeen = new HashSet<BlockPos>(((MarkerConnection)connection).getMarkerPositions());
        this.initConnection(connection, lastSeen);
        if (DEBUG_FULL) {
            this.validateAllConnections();
        }
    }

    public void refreshConnection(@Nonnull C connection) {
        Set<BlockPos> lastSeen = this.connectionToPos.get(connection);
        if (DEBUG_FULL) {
            BCLog.logger.info("[lib.marker.full] Refreshing a connection");
            BCLog.logger.info("[lib.marker.full]    - Old = " + lastSeen);
            BCLog.logger.info("[lib.marker.full]    - New = " + ((MarkerConnection)connection).getMarkerPositions());
        }
        if (lastSeen == null) {
            this.addConnection(connection);
        } else {
            HashSet<BlockPos> invalid = new HashSet<BlockPos>(lastSeen);
            lastSeen = new HashSet<BlockPos>(((MarkerConnection)connection).getMarkerPositions());
            invalid.removeAll(lastSeen);
            this.deinitConnection(invalid);
            this.initConnection(connection, lastSeen);
            if (lastSeen.isEmpty()) {
                this.connectionToPos.remove(connection);
            }
        }
        if (DEBUG_FULL) {
            this.validateAllConnections();
        }
    }

    private void validateAllConnections() {
        String logStart = "[lib.marker.full][" + this.cacheId + "]";
        HashSet<MarkerConnection> visited = new HashSet<MarkerConnection>();
        HashSet<BlockPos> visitedPos = new HashSet<BlockPos>();
        for (Map.Entry<C, Set<BlockPos>> entry : this.connectionToPos.entrySet()) {
            HashSet<BlockPos> actual;
            MarkerConnection con = (MarkerConnection)entry.getKey();
            Set<BlockPos> positions = entry.getValue();
            if (!positions.equals(actual = new HashSet<BlockPos>(con.getMarkerPositions()))) {
                BCLog.logger.warn(logStart + " Positions differed!");
                ArrayList<BlockPos> total = new ArrayList<BlockPos>();
                total.addAll(positions);
                total.addAll(actual);
                for (BlockPos p : total) {
                    String s = "(";
                    s = s + (positions.contains(p) ? "R" : "_");
                    s = s + (actual.contains(p) ? "S" : "_");
                    BCLog.logger.warn(logStart + "  - " + p + " " + s + ")");
                }
            }
            for (BlockPos p : positions) {
                if (visitedPos.contains(p)) {
                    BCLog.logger.warn(logStart + " Duplicate block positions!" + p + " - " + con);
                }
                visitedPos.add(p);
            }
            visited.add(con);
        }
        for (Map.Entry<Object, Set<Object>> entry : this.posToConnection.entrySet()) {
            MarkerConnection connection = (MarkerConnection)((Object)entry.getValue());
            BlockPos p = (BlockPos)entry.getKey();
            if (!visited.contains(connection)) {
                BCLog.logger.warn(logStart + " Unknown connection " + connection + "(" + p + ")");
            }
            if (visitedPos.contains(p)) continue;
            BCLog.logger.warn(logStart + " Unknown Position " + p + " (" + connection + ")");
        }
    }

    private void deinitConnection(Set<BlockPos> set) {
        if (DEBUG_FULL) {
            BCLog.logger.info("[lib.marker.full] Tearing down all connections in " + set);
        }
        for (BlockPos p : set) {
            this.posToConnection.remove(p);
        }
        if (this.isServer && set.size() > 0) {
            MessageMarker message = new MessageMarker();
            message.add = false;
            message.connection = true;
            message.cacheId = this.cacheId;
            message.positions.addAll(set);
            message.count = message.positions.size();
            message.multiple = message.count > 1;
            MessageManager.sendToDimension(message, this.dimensionId);
        }
    }

    private void initConnection(C connection, Set<BlockPos> lastSeen) {
        if (DEBUG_FULL) {
            BCLog.logger.info("[lib.marker.full] Setting up a connection with " + lastSeen);
        }
        if (lastSeen.size() < 2) {
            this.connectionToPos.remove(connection);
            for (BlockPos p : lastSeen) {
                this.posToConnection.remove(p);
            }
            return;
        }
        this.connectionToPos.put(connection, lastSeen);
        for (BlockPos p : lastSeen) {
            this.posToConnection.put(p, connection);
        }
        if (this.isServer && lastSeen.size() > 0) {
            MessageMarker message = new MessageMarker();
            message.add = true;
            message.connection = true;
            message.cacheId = this.cacheId;
            message.positions.addAll(((MarkerConnection)connection).getMarkerPositions());
            message.count = message.positions.size();
            message.multiple = message.count > 1;
            MessageManager.sendToDimension(message, this.dimensionId);
        }
    }

    public ImmutableList<C> getConnections() {
        return ImmutableList.copyOf(this.connectionToPos.keySet());
    }

    public abstract boolean tryConnect(BlockPos var1, BlockPos var2);

    public abstract boolean canConnect(BlockPos var1, BlockPos var2);

    public abstract ImmutableList<BlockPos> getValidConnections(BlockPos var1);

    @SideOnly(value=Side.CLIENT)
    public abstract LaserData_BC8.LaserType getPossibleLaserType();

    @SideOnly(value=Side.CLIENT)
    public final void handleMessageMain(MessageMarker message) {
        block5: {
            if (this.handleMessage(message)) {
                return;
            }
            if (message.connection) break block5;
            List<BlockPos> positions = message.positions;
            if (message.add) {
                for (BlockPos p : positions) {
                    if (this.hasLoadedOrUnloadedMarker(p)) continue;
                    this.loadMarker(p, null);
                }
            } else {
                for (BlockPos p : positions) {
                    this.removeMarker(p);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract boolean handleMessage(MessageMarker var1);
}

