/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.IPlayerOwned;
import com.mojang.authlib.GameProfile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PermissionUtil {
    public static final Object PERM_VIEW = "buildcraft.view";
    public static final Object PERM_EDIT = "buildcraft.edit";
    public static final Object PERM_DESTROY = "buildcraft.destroy";
    private static final int MAX_INTERACT_DISTANCE = 8;
    private static final int MAX_INTERACT_DISTANCE_SQ = 64;

    public static boolean hasPermission(Object type, PermissionBlock attempting, PermissionBlock target) {
        if (type == PERM_DESTROY || type == PERM_EDIT) {
            // empty if block
        }
        return true;
    }

    public static boolean hasPermission(Object type, GameProfile attempting, PermissionBlock target) {
        if (type == PERM_DESTROY || type == PERM_EDIT) {
            // empty if block
        }
        return true;
    }

    public static boolean hasPermission(Object type, EntityPlayer attempting, PermissionBlock target) {
        if (attempting.func_174818_b(target.pos) > 64.0) {
            return false;
        }
        if (type == PERM_DESTROY || type == PERM_EDIT) {
            // empty if block
        }
        return true;
    }

    public static PermissionBlock createFrom(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        IPlayerOwned owned = null;
        if (tile instanceof IPlayerOwned) {
            owned = (IPlayerOwned)tile;
        }
        return new PermissionBlock(owned, pos);
    }

    public static class PermissionBlock {
        public final IPlayerOwned owned;
        public final BlockPos pos;

        public PermissionBlock(IPlayerOwned owned, BlockPos pos) {
            this.owned = owned;
            this.pos = pos;
        }
    }
}

