/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.enums.EnumLaserTableType;
import buildcraft.lib.BCLib;
import buildcraft.lib.registry.RegistrationHelper;
import buildcraft.silicon.block.BlockLaser;
import buildcraft.silicon.block.BlockLaserTable;
import buildcraft.silicon.tile.TileAdvancedCraftingTable;
import buildcraft.silicon.tile.TileAssemblyTable;
import buildcraft.silicon.tile.TileChargingTable;
import buildcraft.silicon.tile.TileIntegrationTable;
import buildcraft.silicon.tile.TileLaser;
import buildcraft.silicon.tile.TileProgrammingTable_Neptune;
import net.minecraft.block.material.Material;

public class BCSiliconBlocks {
    private static final RegistrationHelper HELPER = new RegistrationHelper();
    public static BlockLaser laser;
    public static BlockLaserTable assemblyTable;
    public static BlockLaserTable advancedCraftingTable;
    public static BlockLaserTable integrationTable;
    public static BlockLaserTable chargingTable;
    public static BlockLaserTable programmingTable;

    public static void preInit() {
        laser = HELPER.addBlockAndItem(new BlockLaser(Material.field_151573_f, "block.laser"));
        assemblyTable = BCSiliconBlocks.createLaserTable(EnumLaserTableType.ASSEMBLY_TABLE, "block.assembly_table");
        advancedCraftingTable = BCSiliconBlocks.createLaserTable(EnumLaserTableType.ADVANCED_CRAFTING_TABLE, "block.advanced_crafting_table");
        integrationTable = BCSiliconBlocks.createLaserTable(EnumLaserTableType.INTEGRATION_TABLE, "block.integration_table");
        if (BCLib.DEV) {
            chargingTable = BCSiliconBlocks.createLaserTable(EnumLaserTableType.CHARGING_TABLE, "block.charging_table");
            programmingTable = BCSiliconBlocks.createLaserTable(EnumLaserTableType.PROGRAMMING_TABLE, "block.programming_table");
        }
        HELPER.registerTile(TileLaser.class, "tile.laser");
        HELPER.registerTile(TileAssemblyTable.class, "tile.assembly_table");
        HELPER.registerTile(TileAdvancedCraftingTable.class, "tile.advanced_crafting_table");
        HELPER.registerTile(TileIntegrationTable.class, "tile.integration_table");
        if (BCLib.DEV) {
            HELPER.registerTile(TileChargingTable.class, "tile.charging_table");
            HELPER.registerTile(TileProgrammingTable_Neptune.class, "tile.programming_table");
        }
    }

    private static BlockLaserTable createLaserTable(EnumLaserTableType type, String id) {
        BlockLaserTable block = new BlockLaserTable(type, Material.field_151573_f, id);
        return HELPER.addBlockAndItem(block);
    }
}

