/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import ru.vidtu.ias.account.Account;
import the_fireplace.ias.IAS;

public class Config {
    public static final transient Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).registerTypeAdapter(Account.class, (Object)new IASJsonSerializer()).create();
    public static boolean caseSensitiveSearch;
    public static String textX;
    public static String textY;
    public static String btnX;
    public static String btnY;
    public static boolean showOnMPScreen;
    public static boolean showOnTitleScreen;
    public static List<Account> accounts;

    public static void load(Minecraft mc) {
        try {
            File f = new File(mc.field_71412_D, "config/ias.json");
            if (!f.exists()) {
                return;
            }
            try (FileReader fr = new FileReader(f);){
                GSON.fromJson((Reader)fr, Config.class);
            }
        }
        catch (Throwable t) {
            IAS.LOG.error("Unable to load config", t);
        }
    }

    public static void save(Minecraft mc) {
        try {
            File f = new File(mc.field_71412_D, "config/ias.json");
            if (!f.exists()) {
                f.getParentFile().mkdirs();
            }
            try (FileWriter fw = new FileWriter(f);){
                GSON.toJson((Object)new Config(), (Appendable)fw);
            }
        }
        catch (Throwable t) {
            IAS.LOG.error("Unable to load config", t);
        }
    }

    static {
        showOnTitleScreen = true;
        accounts = new ArrayList<Account>();
    }

    public static class IASJsonSerializer
    implements JsonSerializer<Account>,
    JsonDeserializer<Account> {
        public Account deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject jo = json.getAsJsonObject();
                Class<?> type = Class.forName(jo.get("type").getAsString());
                return (Account)context.deserialize(jo.get("data"), type);
            }
            catch (Throwable t) {
                throw new JsonParseException("Unable to parse account: " + json, t);
            }
        }

        public JsonElement serialize(Account src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jo = new JsonObject();
            jo.addProperty("type", src.getClass().getName());
            jo.add("data", context.serialize((Object)src));
            return jo;
        }
    }
}

