/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.account;

import com.mojang.util.UUIDTypeAdapter;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import org.apache.commons.lang3.tuple.Pair;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.utils.Auth;

public class MicrosoftAccount
implements Account {
    private String username;
    private String accessToken;
    private String refreshToken;
    private UUID uuid;
    private int uses;
    private long lastUse;

    public MicrosoftAccount(String name, String token, String refresh, UUID uuid) {
        this.username = name;
        this.accessToken = token;
        this.refreshToken = refresh;
        this.uuid = uuid;
    }

    @Override
    public String alias() {
        return this.username;
    }

    @Override
    public void login(Minecraft mc, Consumer<Throwable> handler) {
        new Thread(() -> {
            try {
                this.syncRefresh();
            }
            catch (Throwable t) {
                mc.func_152344_a(() -> handler.accept(t));
                return;
            }
            mc.func_152344_a(() -> {
                mc.field_71449_j = new Session(this.username, UUIDTypeAdapter.fromUUID((UUID)this.uuid), this.accessToken, "mojang");
                handler.accept(null);
            });
        }, "IAS MS Reauth Thread").start();
    }

    public void syncRefresh() throws Throwable {
        try {
            Auth.checkGameOwnership(this.accessToken);
            Pair<UUID, String> profile = Auth.getProfile(this.accessToken);
            this.uuid = (UUID)profile.getLeft();
            this.username = (String)profile.getRight();
        }
        catch (Throwable t) {
            try {
                Pair<String, String> authRefreshTokens = Auth.refreshToken(this.refreshToken);
                String refreshToken = (String)authRefreshTokens.getRight();
                String xblToken = Auth.authXBL((String)authRefreshTokens.getLeft());
                Pair<String, String> xstsTokenUserhash = Auth.authXSTS(xblToken);
                String accessToken = Auth.authMinecraft((String)xstsTokenUserhash.getRight(), (String)xstsTokenUserhash.getLeft());
                Auth.checkGameOwnership(accessToken);
                Pair<UUID, String> profile = Auth.getProfile(accessToken);
                this.uuid = (UUID)profile.getLeft();
                this.username = (String)profile.getRight();
                this.accessToken = accessToken;
                this.refreshToken = refreshToken;
            }
            catch (Throwable th) {
                th.addSuppressed(t);
                throw th;
            }
        }
    }

    @Override
    public boolean editable() {
        return false;
    }

    @Override
    public boolean online() {
        return true;
    }

    @Override
    public int uses() {
        return this.uses;
    }

    @Override
    public long lastUse() {
        return this.lastUse;
    }

    @Override
    public void use() {
        ++this.uses;
        this.lastUse = System.currentTimeMillis();
    }

    @Override
    public UUID uuid() {
        return this.uuid;
    }
}

