/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.account;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.AuthException;
import ru.vidtu.ias.utils.Request;

public class MojangAccount
implements Account {
    private String username;
    private String accessToken;
    private UUID clientToken;
    private UUID uuid;
    public int uses;
    public long lastUse;

    public MojangAccount(String username, String accessToken, UUID clientToken, UUID uuid) {
        this.username = username;
        this.accessToken = accessToken;
        this.clientToken = clientToken;
        this.uuid = uuid;
    }

    @Override
    public String alias() {
        return this.username;
    }

    @Override
    public void login(Minecraft mc, Consumer<Throwable> handler) {
        new Thread(() -> {
            try {
                if (!this.validate()) {
                    this.refresh();
                }
            }
            catch (Throwable t) {
                mc.func_152344_a(() -> handler.accept(t));
                return;
            }
            mc.func_152344_a(() -> {
                mc.field_71449_j = new Session(this.username, UUIDTypeAdapter.fromUUID((UUID)this.uuid), this.accessToken, "mojang");
                handler.accept(null);
            });
        }, "IAS Mojang Reauth Thread").start();
    }

    public boolean validate() throws Exception {
        Request r = new Request("https://authserver.mojang.com/validate");
        r.header("Content-Type", "application/json");
        JsonObject jo = new JsonObject();
        jo.addProperty("accessToken", this.accessToken);
        jo.addProperty("clientToken", UUIDTypeAdapter.fromUUID((UUID)this.clientToken));
        r.post(jo.toString());
        return r.response() >= 200 && r.response() < 300;
    }

    public void refresh() throws Exception {
        Request r = new Request("https://authserver.mojang.com/refresh");
        r.header("Content-Type", "application/json");
        JsonObject req = new JsonObject();
        req.addProperty("accessToken", this.accessToken);
        req.addProperty("clientToken", UUIDTypeAdapter.fromUUID((UUID)this.clientToken));
        r.post(req.toString());
        if (r.response() < 200 || r.response() >= 300) {
            throw new AuthException((ITextComponent)new TextComponentTranslation("ias.mojauth.unknown", new Object[]{r.error()}));
        }
        JsonObject resp = (JsonObject)new Gson().fromJson(r.body(), JsonObject.class);
        this.accessToken = resp.get("accessToken").getAsString();
        this.clientToken = UUIDTypeAdapter.fromString((String)resp.get("clientToken").getAsString());
        this.uuid = UUIDTypeAdapter.fromString((String)resp.getAsJsonObject("selectedProfile").get("id").getAsString());
        this.username = resp.getAsJsonObject("selectedProfile").get("name").getAsString();
    }

    @Override
    public boolean editable() {
        return true;
    }

    @Override
    public boolean online() {
        return true;
    }

    @Override
    public int uses() {
        return this.uses;
    }

    @Override
    public long lastUse() {
        return this.lastUse;
    }

    @Override
    public void use() {
        ++this.uses;
        this.lastUse = System.currentTimeMillis();
    }

    @Override
    public UUID uuid() {
        return this.uuid;
    }
}

