/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.gui;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.Sys;
import ru.vidtu.ias.Config;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.AuthException;
import ru.vidtu.ias.account.MicrosoftAccount;
import ru.vidtu.ias.utils.Auth;
import the_fireplace.ias.IAS;

public class MSAuthScreen
extends GuiScreen {
    public static final String[] symbols = new String[]{"\u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453", "_ \u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e", "_ _ \u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026", "_ _ _ \u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020", "_ _ _ _ \u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021", "_ _ _ _ _ \u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac", "_ _ _ _ \u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021", "_ _ _ \u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020", "_ _ \u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026", "_ \u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e", "\u0432\u2013\u0453 \u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453", "\u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453 _", "\u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453 _ _", "\u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453 _ _ _", "\u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453 _ _ _ _", "\u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453 _ _ _ _ _", "\u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453 _ _ _ _", "\u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453 _ _ _", "\u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453 _ _", "\u0432\u2013\u201e \u0432\u2013\u2026 \u0432\u2013\u2020 \u0432\u2013\u2021 \u0432\u2013\u20ac \u0432\u2013\u2021 \u0432\u2013\u2020 \u0432\u2013\u2026 \u0432\u2013\u201e \u0432\u2013\u0453 _"};
    public final GuiScreen prev;
    private HttpServer srv;
    private int tick;
    private String state = I18n.func_135052_a((String)"ias.msauth.checkbrowser", (Object[])new Object[0]);
    private List<String> error;
    private Consumer<Account> handler;

    public MSAuthScreen(GuiScreen prev, Consumer<Account> handler) {
        this.prev = prev;
        this.handler = handler;
        final String done = "<html><body><h1>" + I18n.func_135052_a((String)"ias.msauth.canclosenow", (Object[])new Object[0]) + "</h1></body></html>";
        new Thread(() -> {
            try {
                this.srv = HttpServer.create(new InetSocketAddress(59125), 0);
                this.srv.createContext("/", new HttpHandler(){

                    @Override
                    public void handle(HttpExchange ex) throws IOException {
                        try {
                            ex.getResponseHeaders().add("Location", "http://localhost:59125/end");
                            ex.sendResponseHeaders(302, -1L);
                            new Thread(() -> MSAuthScreen.this.auth(ex.getRequestURI().getQuery()), "IAS MS Auth Thread").start();
                        }
                        catch (Throwable t) {
                            IAS.LOG.warn("Unable to process request 'auth' on MS auth server", t);
                            try {
                                if (MSAuthScreen.this.srv != null) {
                                    MSAuthScreen.this.srv.stop(0);
                                }
                            }
                            catch (Throwable th) {
                                IAS.LOG.warn("Unable to stop fail-requested MS auth server", th);
                            }
                        }
                    }
                });
                this.srv.createContext("/end", new HttpHandler(){

                    @Override
                    public void handle(HttpExchange ex) throws IOException {
                        try {
                            byte[] b = done.getBytes(StandardCharsets.UTF_8);
                            ex.getResponseHeaders().put("Content-Type", Arrays.asList("text/html; charset=UTF-8"));
                            ex.sendResponseHeaders(200, b.length);
                            OutputStream os = ex.getResponseBody();
                            os.write(b);
                            os.flush();
                            os.close();
                            try {
                                if (MSAuthScreen.this.srv != null) {
                                    MSAuthScreen.this.srv.stop(0);
                                }
                            }
                            catch (Throwable th) {
                                IAS.LOG.warn("Unable to stop MS auth server", th);
                            }
                        }
                        catch (Throwable t) {
                            IAS.LOG.warn("Unable to process request 'end' on MS auth server", t);
                            try {
                                if (MSAuthScreen.this.srv != null) {
                                    MSAuthScreen.this.srv.stop(0);
                                }
                            }
                            catch (Throwable th) {
                                IAS.LOG.warn("Unable to stop fail-requested MS auth server", th);
                            }
                        }
                    }
                });
                this.srv.start();
                Sys.openURL((String)"https://login.live.com/oauth20_authorize.srf?client_id=54fd49e4-2103-4044-9603-2b028c814ec3&response_type=code&scope=XboxLive.signin%20XboxLive.offline_access&redirect_uri=http://localhost:59125&prompt=consent");
            }
            catch (Throwable t) {
                IAS.LOG.warn("Unable to start MS auth server", t);
                try {
                    if (this.srv != null) {
                        this.srv.stop(0);
                    }
                }
                catch (Throwable th) {
                    IAS.LOG.warn("Unable to stop fail-started MS auth server", th);
                }
                this.error(t);
            }
        }, "IAS MS Auth Server Thread").start();
    }

    private void auth(String query) {
        try {
            this.state = I18n.func_135052_a((String)"ias.msauth.progress", (Object[])new Object[0]);
            if (query == null) {
                throw new NullPointerException("query=null");
            }
            if (query.equals("error=access_denied&error_description=The user has denied access to the scope requested by the client application.")) {
                throw new AuthException((ITextComponent)new TextComponentTranslation("ias.msauth.error.revoked", new Object[0]));
            }
            if (!query.startsWith("code=")) {
                throw new IllegalStateException("query=" + query);
            }
            Pair<String, String> authRefreshTokens = Auth.authCode2Token(query.replace("code=", ""));
            String refreshToken = (String)authRefreshTokens.getRight();
            String xblToken = Auth.authXBL((String)authRefreshTokens.getLeft());
            Pair<String, String> xstsTokenUserhash = Auth.authXSTS(xblToken);
            String accessToken = Auth.authMinecraft((String)xstsTokenUserhash.getRight(), (String)xstsTokenUserhash.getLeft());
            Auth.checkGameOwnership(accessToken);
            Pair<UUID, String> profile = Auth.getProfile(accessToken);
            if (Config.accounts.stream().anyMatch(acc -> acc.alias().equalsIgnoreCase((String)profile.getRight()))) {
                throw new AuthException((ITextComponent)new TextComponentTranslation("ias.auth.alreadyexists", new Object[0]));
            }
            this.field_146297_k.func_152344_a(() -> {
                if (this.field_146297_k.field_71462_r == this) {
                    this.handler.accept(new MicrosoftAccount((String)profile.getRight(), accessToken, refreshToken, (UUID)profile.getLeft()));
                    this.field_146297_k.func_147108_a(this.prev);
                }
            });
        }
        catch (Throwable t) {
            IAS.LOG.warn("Unable to auth thru MS", t);
            this.error(t);
        }
    }

    public void error(Throwable t) {
        this.field_146297_k.func_152344_a(() -> {
            this.error = t instanceof AuthException ? this.field_146289_q.func_78271_c(((AuthException)t).getText().func_150254_d(), this.field_146294_l - 20) : this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"ias.auth.unknown", (Object[])new Object[]{t.toString()}), this.field_146294_l - 20);
        });
    }

    public void func_73866_w_() {
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 75, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(this.prev);
        }
    }

    public void func_73876_c() {
        ++this.tick;
    }

    public void func_146281_b() {
        try {
            if (this.srv != null) {
                this.srv.stop(0);
            }
        }
        catch (Throwable t) {
            IAS.LOG.warn("Unable to stop MS auth server", t);
        }
        super.func_146281_b();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.prev);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"ias.msauth.title", (Object[])new Object[0]), this.field_146294_l / 2, 7, -1);
        if (this.error != null) {
            for (int i = 0; i < this.error.size(); ++i) {
                this.func_73732_a(this.field_146289_q, this.error.get(i), this.field_146294_l / 2, this.field_146295_m / 2 - 5 + i * 10 - this.error.size() * 5, -65536);
                if (i <= 6) {
                    continue;
                }
                break;
            }
        } else {
            this.func_73732_a(this.field_146289_q, this.state, this.field_146294_l / 2, this.field_146295_m / 2 - 10, -1);
            this.func_73732_a(this.field_146289_q, symbols[this.tick % symbols.length], this.field_146294_l / 2, this.field_146295_m / 2, -26368);
        }
        super.func_73863_a(mouseX, mouseY, delta);
    }
}

