/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.lang3.tuple.Pair;
import ru.vidtu.ias.account.AuthException;
import ru.vidtu.ias.account.MojangAccount;
import ru.vidtu.ias.utils.Request;
import the_fireplace.ias.IAS;

public class Auth {
    public static Pair<String, String> authCode2Token(String code) throws IllegalArgumentException, Exception {
        Request pr = new Request("https://login.live.com/oauth20_token.srf");
        pr.header("Content-Type", "application/x-www-form-urlencoded");
        HashMap<Object, Object> req = new HashMap<Object, Object>();
        req.put("client_id", "54fd49e4-2103-4044-9603-2b028c814ec3");
        req.put("code", code);
        req.put("grant_type", "authorization_code");
        req.put("redirect_uri", "http://localhost:59125");
        req.put("scope", "XboxLive.signin XboxLive.offline_access");
        pr.post(req);
        if (pr.response() < 200 || pr.response() >= 300) {
            throw new IllegalArgumentException("authCode2Token response: " + pr.response());
        }
        JsonObject resp = (JsonObject)IAS.GSON.fromJson(pr.body(), JsonObject.class);
        return Pair.of((Object)resp.get("access_token").getAsString(), (Object)resp.get("refresh_token").getAsString());
    }

    public static Pair<String, String> refreshToken(String refreshToken) throws IllegalArgumentException, Exception {
        Request r = new Request("https://login.live.com/oauth20_token.srf");
        r.get();
        HashMap<Object, Object> req = new HashMap<Object, Object>();
        req.put("client_id", "54fd49e4-2103-4044-9603-2b028c814ec3");
        req.put("refresh_token", refreshToken);
        req.put("grant_type", "refresh_token");
        req.put("redirect_uri", "http://localhost:59125");
        r.post(req);
        if (r.response() < 200 || r.response() >= 300) {
            throw new IllegalArgumentException("refreshToken response: " + r.response());
        }
        JsonObject resp = (JsonObject)IAS.GSON.fromJson(r.body(), JsonObject.class);
        return Pair.of((Object)resp.get("access_token").getAsString(), (Object)resp.get("refresh_token").getAsString());
    }

    public static String authXBL(String authToken) throws IllegalArgumentException, Exception {
        Request pr = new Request("https://user.auth.xboxlive.com/user/authenticate");
        pr.header("Content-Type", "application/json");
        pr.header("Accept", "application/json");
        JsonObject req = new JsonObject();
        JsonObject reqProps = new JsonObject();
        reqProps.addProperty("AuthMethod", "RPS");
        reqProps.addProperty("SiteName", "user.auth.xboxlive.com");
        reqProps.addProperty("RpsTicket", "d=" + authToken);
        req.add("Properties", (JsonElement)reqProps);
        req.addProperty("RelyingParty", "http://auth.xboxlive.com");
        req.addProperty("TokenType", "JWT");
        pr.post(req.toString());
        if (pr.response() < 200 || pr.response() >= 300) {
            throw new IllegalArgumentException("authXBL response: " + pr.response());
        }
        return ((JsonObject)IAS.GSON.fromJson(pr.body(), JsonObject.class)).get("Token").getAsString();
    }

    public static Pair<String, String> authXSTS(String xblToken) throws AuthException, IllegalArgumentException, Exception {
        Request pr = new Request("https://xsts.auth.xboxlive.com/xsts/authorize");
        pr.header("Content-Type", "application/json");
        pr.header("Accept", "application/json");
        JsonObject req = new JsonObject();
        JsonObject reqProps = new JsonObject();
        JsonArray userTokens = new JsonArray();
        userTokens.add(xblToken);
        reqProps.add("UserTokens", (JsonElement)userTokens);
        reqProps.addProperty("SandboxId", "RETAIL");
        req.add("Properties", (JsonElement)reqProps);
        req.addProperty("RelyingParty", "rp://api.minecraftservices.com/");
        req.addProperty("TokenType", "JWT");
        pr.post(req.toString());
        if (pr.response() == 401) {
            throw new AuthException((ITextComponent)new TextComponentTranslation("ias.msauth.error.noxbox", new Object[0]));
        }
        if (pr.response() < 200 || pr.response() >= 300) {
            throw new IllegalArgumentException("authXSTS response: " + pr.response());
        }
        JsonObject resp = (JsonObject)IAS.GSON.fromJson(pr.body(), JsonObject.class);
        return Pair.of((Object)resp.get("Token").getAsString(), (Object)resp.getAsJsonObject("DisplayClaims").getAsJsonArray("xui").get(0).getAsJsonObject().get("uhs").getAsString());
    }

    public static String authMinecraft(String userHash, String xstsToken) throws IllegalArgumentException, Exception {
        Request pr = new Request("https://api.minecraftservices.com/authentication/login_with_xbox");
        pr.header("Content-Type", "application/json");
        pr.header("Accept", "application/json");
        JsonObject req = new JsonObject();
        req.addProperty("identityToken", "XBL3.0 x=" + userHash + ";" + xstsToken);
        pr.post(req.toString());
        if (pr.response() < 200 || pr.response() >= 300) {
            throw new IllegalArgumentException("authMinecraft response: " + pr.response());
        }
        return ((JsonObject)IAS.GSON.fromJson(pr.body(), JsonObject.class)).get("access_token").getAsString();
    }

    public static void checkGameOwnership(String accessToken) throws AuthException, IllegalArgumentException, Exception {
        Request pr = new Request("https://api.minecraftservices.com/entitlements/mcstore");
        pr.header("Authorization", "Bearer " + accessToken);
        pr.get();
        if (pr.response() < 200 || pr.response() >= 300) {
            throw new IllegalArgumentException("checkGameOwnership response: " + pr.response());
        }
        if (((JsonObject)IAS.GSON.fromJson(pr.body(), JsonObject.class)).getAsJsonArray("items").size() == 0) {
            throw new AuthException((ITextComponent)new TextComponentTranslation("ias.msauth.error.gamenotowned", new Object[0]));
        }
    }

    public static Pair<UUID, String> getProfile(String accessToken) throws IllegalArgumentException, Exception {
        Request pr = new Request("https://api.minecraftservices.com/minecraft/profile");
        pr.header("Authorization", "Bearer " + accessToken);
        pr.get();
        if (pr.response() < 200 || pr.response() >= 300) {
            throw new IllegalArgumentException("getProfile response: " + pr.response());
        }
        JsonObject resp = (JsonObject)IAS.GSON.fromJson(pr.body(), JsonObject.class);
        return Pair.of((Object)UUIDTypeAdapter.fromString((String)resp.get("id").getAsString()), (Object)resp.get("name").getAsString());
    }

    public static MojangAccount authMojang(String name, String pwd) throws AuthException, IOException {
        Request r = new Request("https://authserver.mojang.com/authenticate");
        r.header("Content-Type", "application/json");
        UUID clientToken = UUID.randomUUID();
        JsonObject req = new JsonObject();
        JsonObject agent = new JsonObject();
        agent.addProperty("name", "Minecraft");
        agent.addProperty("version", (Number)1);
        req.add("agent", (JsonElement)agent);
        req.addProperty("username", name);
        req.addProperty("password", pwd);
        req.addProperty("clientToken", UUIDTypeAdapter.fromUUID((UUID)clientToken));
        r.post(req.toString());
        if (r.response() < 200 || r.response() >= 300) {
            JsonObject jo = new JsonObject();
            String reqerr = r.error();
            try {
                jo = (JsonObject)new Gson().fromJson(reqerr, JsonObject.class);
            }
            catch (Exception ex) {
                if (reqerr.toLowerCase().contains("cloudfront")) {
                    throw new AuthException((ITextComponent)new TextComponentTranslation("ias.mojauth.toofast", new Object[0]), reqerr);
                }
                throw new AuthException((ITextComponent)new TextComponentTranslation("ias.mojauth.unknown", new Object[]{reqerr}), reqerr);
            }
            String err = jo.get("error").getAsString();
            if (err.equals("ForbiddenOperationException")) {
                String msg = jo.get("errorMessage").getAsString();
                if (msg.equals("Invalid credentials. Invalid username or password.")) {
                    throw new AuthException((ITextComponent)new TextComponentTranslation("ias.mojauth.invalidcreds", new Object[0]), jo.toString());
                }
                if (msg.equals("Invalid credentials.")) {
                    throw new AuthException((ITextComponent)new TextComponentTranslation("ias.mojauth.toofast", new Object[0]), jo.toString());
                }
            }
            if (err.equals("ResourceException")) {
                throw new AuthException((ITextComponent)new TextComponentTranslation("ias.mojauth.migrated", new Object[0]), jo.toString());
            }
            throw new AuthException((ITextComponent)new TextComponentTranslation("ias.mojauth.unknown", new Object[]{jo.toString()}));
        }
        JsonObject resp = (JsonObject)new Gson().fromJson(r.body(), JsonObject.class);
        String accessToken = resp.get("accessToken").getAsString();
        UUID respClientToken = UUIDTypeAdapter.fromString((String)resp.get("clientToken").getAsString());
        if (!respClientToken.equals(clientToken)) {
            throw new AuthException((ITextComponent)new TextComponentTranslation("ias.mojauth.unknown", new Object[]{"Response token " + respClientToken + " is not equals to sent token " + clientToken}));
        }
        UUID uuid = UUIDTypeAdapter.fromString((String)resp.getAsJsonObject("selectedProfile").get("id").getAsString());
        String username = resp.getAsJsonObject("selectedProfile").get("name").getAsString();
        return new MojangAccount(username, accessToken, clientToken, uuid);
    }
}

