/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.utils;

import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import ru.vidtu.ias.Config;
import ru.vidtu.ias.account.Account;
import the_fireplace.ias.IAS;

public class SkinRenderer {
    public static void loadAllAsync(Minecraft mc, boolean forceRecache, Runnable onEnd) {
        GuiScreen prev = mc.field_71462_r;
        SkinsLoadingScreen sls = new SkinsLoadingScreen();
        mc.func_147108_a((GuiScreen)sls);
        new Thread(() -> {
            List<Account> accs = Config.accounts;
            for (int i = 0; i < accs.size(); ++i) {
                sls.progress = ((float)i + 1.0f) / (float)accs.size();
                Account data = accs.get(i);
                SkinRenderer.loadSkin(mc, data.alias(), data.uuid(), forceRecache);
            }
            sls.progress = 1.0f;
            mc.func_152344_a(() -> mc.func_147108_a(prev));
            mc.func_152344_a(onEnd);
        }, "IAS Skin Cache Thread").start();
    }

    public static void loadSkin(Minecraft mc, String name, UUID uuid, boolean forceRecache) {
        SkinRenderer.loadSkin(mc, name, uuid, new File(new File(mc.field_71412_D, "cachedImages/models"), name + ".png"), new File(new File(mc.field_71412_D, "cachedImages/faces"), name + ".png"), forceRecache);
    }

    public static void loadSkin(Minecraft mc, String name, UUID uuid, File modelF, File faceF, boolean forceRecache) {
        if (!modelF.exists() || forceRecache) {
            BufferedImage img;
            boolean slimSkin = false;
            try {
                String base64Data;
                modelF.getParentFile().mkdirs();
                if (uuid == null) {
                    try (InputStreamReader isr = new InputStreamReader(new URL("https://api.mojang.com/users/profiles/minecraft/" + name).openStream(), StandardCharsets.UTF_8);){
                        uuid = UUIDTypeAdapter.fromString((String)((JsonObject)IAS.GSON.fromJson((Reader)isr, JsonObject.class)).get("id").getAsString());
                    }
                }
                try (InputStreamReader isr = new InputStreamReader(new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDTypeAdapter.fromUUID((UUID)uuid)).openStream(), StandardCharsets.UTF_8);){
                    base64Data = ((JsonObject)IAS.GSON.fromJson((Reader)isr, JsonObject.class)).getAsJsonArray("properties").get(0).getAsJsonObject().get("value").getAsString();
                }
                JsonObject jo = ((JsonObject)IAS.GSON.fromJson(new String(Base64.getDecoder().decode(base64Data), StandardCharsets.UTF_8), JsonObject.class)).getAsJsonObject("textures").getAsJsonObject("SKIN");
                if (jo.has("metadata") && jo.getAsJsonObject("metadata").has("model") && jo.getAsJsonObject("metadata").get("model").getAsString().equalsIgnoreCase("slim")) {
                    slimSkin = true;
                }
                String skinUrl = jo.get("url").getAsString();
                img = ImageIO.read(new URL(skinUrl));
            }
            catch (Throwable t) {
                try (InputStream is = mc.func_110442_L().func_110536_a(new ResourceLocation("textures/entity/steve.png")).func_110527_b();){
                    img = ImageIO.read(is);
                }
                catch (Throwable th) {
                    th.addSuppressed(t);
                    IAS.LOG.warn("Unable to load skin: " + name, th);
                    return;
                }
            }
            try {
                boolean oldSkin;
                BufferedImage model = new BufferedImage(16, 32, 2);
                if (img.getWidth() != 64 && (img.getHeight() != 64 || img.getHeight() != 32)) {
                    throw new IllegalStateException("Invalid skin size: " + img.getWidth() + "x" + img.getHeight());
                }
                boolean bl = oldSkin = img.getHeight() == 32;
                if (oldSkin) {
                    slimSkin = false;
                }
                model.getGraphics().drawImage(img.getSubimage(8, 8, 8, 8), 4, 0, null);
                model.getGraphics().drawImage(img.getSubimage(20, 20, 8, 12), 4, 8, null);
                model.getGraphics().drawImage(img.getSubimage(44, 20, slimSkin ? 3 : 4, 12), slimSkin ? 1 : 0, 8, null);
                model.getGraphics().drawImage(img.getSubimage(oldSkin ? 44 : 36, oldSkin ? 20 : 52, slimSkin ? 3 : 4, 12), 12, 8, null);
                model.getGraphics().drawImage(img.getSubimage(4, 20, 4, 12), 4, 20, null);
                model.getGraphics().drawImage(img.getSubimage(oldSkin ? 4 : 20, oldSkin ? 20 : 52, 4, 12), 8, 20, null);
                model.getGraphics().drawImage(img.getSubimage(40, 8, 8, 8), 4, 0, null);
                if (!oldSkin) {
                    model.getGraphics().drawImage(img.getSubimage(20, 36, 8, 12), 4, 8, null);
                    model.getGraphics().drawImage(img.getSubimage(44, 36, 4, 12), 0, 8, null);
                    model.getGraphics().drawImage(img.getSubimage(52, 52, 4, 12), 12, 8, null);
                    model.getGraphics().drawImage(img.getSubimage(4, 36, 4, 12), 4, 20, null);
                    model.getGraphics().drawImage(img.getSubimage(4, 52, 4, 12), 8, 20, null);
                }
                ImageIO.write((RenderedImage)model, "png", modelF);
            }
            catch (Throwable t) {
                IAS.LOG.warn("Unable to make model of skin: " + name, t);
            }
        }
        if (!faceF.exists()) {
            faceF.getParentFile().mkdirs();
            try {
                ImageIO.write((RenderedImage)ImageIO.read(modelF).getSubimage(4, 0, 8, 8), "png", faceF);
            }
            catch (Throwable t) {
                IAS.LOG.warn("Unable to make face from skin model: " + name, t);
            }
        }
    }

    public static class SkinsLoadingScreen
    extends GuiScreen {
        private static final ResourceLocation PROGRESS = new ResourceLocation("ias", "textures/iaslogo.png");
        public float progress;
        public float smoothProgress;

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            if (this.smoothProgress < this.progress) {
                this.smoothProgress += (this.progress - this.smoothProgress) / 16.0f;
            }
            SkinsLoadingScreen.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-15724528);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(PROGRESS);
            SkinsLoadingScreen.func_146110_a((int)(this.field_146294_l / 2 - 25), (int)(this.field_146295_m / 2 - 25), (float)0.0f, (float)0.0f, (int)50, (int)50, (float)50.0f, (float)50.0f);
            SkinsLoadingScreen.func_73734_a((int)30, (int)(this.field_146295_m / 4 * 3), (int)(this.field_146294_l - 30), (int)(this.field_146295_m / 4 * 3 + 10), (int)-1);
            SkinsLoadingScreen.func_73734_a((int)31, (int)(this.field_146295_m / 4 * 3 + 1), (int)(this.field_146294_l - 31), (int)(this.field_146295_m / 4 * 3 + 9), (int)-16777216);
            SkinsLoadingScreen.func_73734_a((int)31, (int)(this.field_146295_m / 4 * 3 + 1), (int)((int)(31.0f + (float)(this.field_146294_l - 61) * this.smoothProgress)), (int)(this.field_146295_m / 4 * 3 + 9), (int)-16733696);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        public void func_73869_a(char typedChar, int keyCode) {
        }
    }
}

