/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.gui;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import ru.vidtu.ias.Config;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.AuthException;
import ru.vidtu.ias.account.MojangAccount;
import ru.vidtu.ias.account.OfflineAccount;
import ru.vidtu.ias.gui.MSAuthScreen;
import ru.vidtu.ias.utils.Auth;
import ru.vidtu.ias.utils.SkinRenderer;
import the_fireplace.ias.IAS;
import the_fireplace.ias.gui.GuiPasswordField;

public class AbstractAccountGui
extends GuiScreen {
    public final GuiScreen prev;
    public final String title;
    private GuiTextField username;
    private GuiTextField password;
    private GuiButton complete;
    private boolean logging;
    private Consumer<Account> handler;
    private List<String> error;

    public AbstractAccountGui(GuiScreen prev, String title, Consumer<Account> handler) {
        this.title = title;
        this.prev = prev;
        this.handler = handler;
    }

    public void func_73866_w_() {
        this.complete = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 152, this.field_146295_m - 28, 150, 20, this.title));
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 2, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.username = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 - 100, 60, 200, 20);
        this.username.func_146203_f(512);
        this.password = new GuiPasswordField(3, this.field_146289_q, this.field_146294_l / 2 - 100, 90, 200, 20);
        this.password.func_146203_f(512);
        this.complete.field_146124_l = false;
        this.func_189646_b(new GuiButton(4, this.field_146294_l / 2 - 50, this.field_146295_m / 3 * 2, 100, 20, I18n.func_135052_a((String)"ias.msauth.btn", (Object[])new Object[0])));
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.end();
        }
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(this.prev);
        }
        if (button.field_146127_k == 4) {
            this.field_146297_k.func_147108_a((GuiScreen)new MSAuthScreen(this.prev, this.handler));
        }
    }

    public void func_73863_a(int mx, int my, float delta) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 7, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"ias.username", (Object[])new Object[0]), this.field_146294_l / 2 - 130, 66, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"ias.password", (Object[])new Object[0]), this.field_146294_l / 2 - 130, 96, -1);
        if (this.error != null) {
            for (int i = 0; i < this.error.size(); ++i) {
                this.func_73732_a(this.field_146289_q, this.error.get(i), this.field_146294_l / 2, 114 + i * 10, -65536);
                if (i > 6) break;
            }
        }
        this.username.func_146194_f();
        this.password.func_146194_f();
        super.func_73863_a(mx, my, delta);
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.username.func_146192_a(mouseX, mouseY, mouseButton);
        this.password.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.prev);
            return;
        }
        if (keyCode == 28) {
            if (this.username.func_146206_l()) {
                this.username.func_146195_b(false);
                this.password.func_146195_b(true);
                return;
            }
            if (this.password.func_146206_l() && this.complete.field_146124_l) {
                this.end();
                return;
            }
        }
        this.username.func_146201_a(typedChar, keyCode);
        this.password.func_146201_a(typedChar, keyCode);
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73876_c() {
        this.complete.field_146124_l = !this.username.func_146179_b().trim().isEmpty() && !this.logging;
        this.complete.field_146126_j = !this.username.func_146179_b().trim().isEmpty() && this.password.func_146179_b().isEmpty() ? this.title + " " + I18n.func_135052_a((String)"ias.offline", (Object[])new Object[0]) : this.title;
        this.username.func_146184_c(!this.logging);
        this.password.func_146184_c(!this.logging);
        this.username.func_146178_a();
        this.password.func_146178_a();
        super.func_73876_c();
    }

    public void end() {
        if (this.password.func_146179_b().isEmpty()) {
            String name = this.username.func_146179_b();
            if (Config.accounts.stream().anyMatch(acc -> acc.alias().equalsIgnoreCase(name))) {
                this.error = this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"ias.auth.alreadyexists", (Object[])new Object[0]), this.field_146294_l - 10);
                return;
            }
            this.logging = true;
            new Thread(() -> {
                SkinRenderer.loadSkin(this.field_146297_k, name, null, false);
                this.field_146297_k.func_152344_a(() -> {
                    if (this.field_146297_k.field_71462_r == this) {
                        this.handler.accept(new OfflineAccount(this.username.func_146179_b()));
                        this.field_146297_k.func_147108_a(this.prev);
                    }
                });
                this.logging = false;
            }).start();
        } else {
            String name = this.username.func_146179_b();
            String pwd = this.password.func_146179_b();
            this.logging = true;
            new Thread(() -> {
                try {
                    MojangAccount ma = Auth.authMojang(name, pwd);
                    SkinRenderer.loadSkin(this.field_146297_k, ma.alias(), ma.uuid(), false);
                    if (Config.accounts.stream().anyMatch(acc -> acc.alias().equalsIgnoreCase(name))) {
                        throw new AuthException((ITextComponent)new TextComponentTranslation("ias.auth.alreadyexists", new Object[0]));
                    }
                    this.field_146297_k.func_152344_a(() -> {
                        if (this.field_146297_k.field_71462_r == this) {
                            this.handler.accept(ma);
                            this.field_146297_k.func_147108_a(this.prev);
                        }
                    });
                }
                catch (AuthException ae) {
                    IAS.LOG.warn("Unable to add account (expected exception)", (Throwable)ae);
                    this.field_146297_k.func_152343_a(() -> {
                        this.error = this.field_146289_q.func_78271_c(ae.getText().func_150254_d(), this.field_146294_l - 10);
                        return this.error;
                    });
                }
                catch (Throwable t) {
                    IAS.LOG.warn("Unable to add account (unexpected exception)", t);
                    this.field_146297_k.func_152343_a(() -> {
                        this.error = this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"ias.auth.unknown", (Object[])new Object[]{t.getLocalizedMessage()}), this.field_146294_l - 10);
                        return this.error;
                    });
                }
                this.logging = false;
            }, "IAS Mojang Auth Thread").start();
        }
    }
}

