/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.gui;

import com.github.mrebhan.ingameaccountswitcher.tools.Tools;
import com.mojang.util.UUIDTypeAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.util.SoundEvent;
import ru.vidtu.ias.Config;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.AuthException;
import ru.vidtu.ias.gui.SuggestorTextField;
import ru.vidtu.ias.utils.SkinRenderer;
import the_fireplace.ias.IAS;
import the_fireplace.ias.gui.AbstractAccountGui;

public class GuiAccountSelector
extends GuiScreen {
    public final GuiScreen prev;
    private boolean logging;
    private String error;
    private AccountList accountsgui;
    private GuiButton login;
    private GuiButton loginoffline;
    private GuiButton delete;
    private GuiButton edit;
    private GuiButton reloadskins;
    private String prevQuery = "";
    private SuggestorTextField search;

    public GuiAccountSelector(GuiScreen prev) {
        this.prev = prev;
    }

    public void func_73866_w_() {
        if (this.accountsgui == null) {
            this.accountsgui = new AccountList(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
        this.reloadskins = new GuiButton(0, 2, 2, 120, 20, I18n.func_135052_a((String)"ias.reloadskins", (Object[])new Object[0]));
        this.func_189646_b(this.reloadskins);
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 4 + 40, this.field_146295_m - 52, 120, 20, I18n.func_135052_a((String)"ias.addaccount", (Object[])new Object[0])));
        this.login = new GuiButton(2, this.field_146294_l / 2 - 154 - 10, this.field_146295_m - 52, 120, 20, I18n.func_135052_a((String)"ias.login", (Object[])new Object[0]));
        this.func_189646_b(this.login);
        this.edit = new GuiButton(3, this.field_146294_l / 2 - 40, this.field_146295_m - 52, 80, 20, I18n.func_135052_a((String)"ias.edit", (Object[])new Object[0]));
        this.func_189646_b(this.edit);
        this.loginoffline = new GuiButton(4, this.field_146294_l / 2 - 154 - 10, this.field_146295_m - 28, 110, 20, I18n.func_135052_a((String)"ias.login", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"ias.offline", (Object[])new Object[0]));
        this.func_189646_b(this.loginoffline);
        this.func_189646_b(new GuiButton(5, this.field_146294_l / 2 + 4 + 50, this.field_146295_m - 28, 110, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.delete = new GuiButton(6, this.field_146294_l / 2 - 50, this.field_146295_m - 28, 100, 20, I18n.func_135052_a((String)"ias.delete", (Object[])new Object[0]));
        this.func_189646_b(this.delete);
        this.search = new SuggestorTextField(7, this.field_146289_q, this.field_146294_l / 2 - 80, 14, 160, 16, I18n.func_135052_a((String)"ias.search", (Object[])new Object[0]));
        this.updateButtons();
        this.accountsgui.resize(this.field_146294_l, this.field_146295_m);
        this.accountsgui.updateAccounts();
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.reloadSkins();
        }
        if (button.field_146127_k == 1) {
            this.add();
        }
        if (button.field_146127_k == 2) {
            this.accountsgui.login();
        }
        if (button.field_146127_k == 3) {
            this.accountsgui.edit();
        }
        if (button.field_146127_k == 4) {
            this.accountsgui.loginOffline();
        }
        if (button.field_146127_k == 5) {
            this.field_146297_k.func_147108_a(this.prev);
        }
        if (button.field_146127_k == 6) {
            this.accountsgui.delete();
        }
    }

    public void func_73876_c() {
        this.search.func_146178_a();
        this.updateButtons();
        if (!this.prevQuery.equals(this.search.func_146179_b())) {
            this.accountsgui.updateAccounts();
            this.prevQuery = this.search.func_146179_b();
        }
    }

    public void func_146281_b() {
        Config.save(this.field_146297_k);
    }

    public void func_73863_a(int mx, int my, float delta) {
        this.func_146276_q_();
        this.accountsgui.func_148128_a(mx, my, delta);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"ias.selectaccount", (Object[])new Object[0]), this.field_146294_l / 2, 4, -1);
        if (this.error != null) {
            this.func_73732_a(this.field_146289_q, this.error, this.field_146294_l / 2, this.field_146295_m - 62, 0xFF6464);
        }
        super.func_73863_a(mx, my, delta);
        if (this.accountsgui.selected() >= 0) {
            Account acc = this.accountsgui.entries.get((int)this.accountsgui.selected()).account;
            this.field_146297_k.func_110434_K().func_110577_a(this.accountsgui.entries.get(this.accountsgui.selected()).model(false));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiAccountSelector.func_146110_a((int)8, (int)(this.field_146295_m / 2 - 64 - 16), (float)0.0f, (float)0.0f, (int)64, (int)128, (float)64.0f, (float)128.0f);
            Tools.drawBorderedRect(this.field_146294_l - 8 - 64, this.field_146295_m / 2 - 64 - 16, this.field_146294_l - 8, this.field_146295_m / 2 + 64 - 16, 2, -5855578, -13421773);
            if (acc.online()) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.premium", (Object[])new Object[0]), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 13, 0x64FF64);
            } else {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.notpremium", (Object[])new Object[0]), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 13, 0xFF6464);
            }
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.timesused", (Object[])new Object[0]), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 15 + 12, -1);
            this.func_73731_b(this.field_146289_q, String.valueOf(acc.uses()), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 15 + 21, -1);
            if (acc.uses() > 0) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.lastused", (Object[])new Object[0]), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 15 + 30, -1);
                this.func_73731_b(this.field_146289_q, DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).format(Instant.ofEpochMilli(acc.lastUse()).atZone(ZoneId.systemDefault())), this.field_146294_l - 8 - 61, this.field_146295_m / 2 - 64 - 15 + 39, -1);
            }
        }
        this.search.func_146194_f();
    }

    private void reloadSkins() {
        Config.save(this.field_146297_k);
        SkinRenderer.loadAllAsync(this.field_146297_k, true, () -> this.accountsgui.entries.forEach(ae -> {
            ae.model(true);
            ae.face(true);
        }));
    }

    private void add() {
        this.field_146297_k.func_147108_a((GuiScreen)new AbstractAccountGui(this, I18n.func_135052_a((String)"ias.addaccount", (Object[])new Object[0]), acc -> {
            Config.accounts.add((Account)acc);
            Config.save(this.field_146297_k);
            this.accountsgui.updateAccounts();
        }));
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.prev);
            return;
        }
        if (this.search.func_146206_l()) {
            if (keyCode == 28 && this.search.func_146206_l()) {
                this.search.func_146195_b(false);
                return;
            }
        } else {
            if (keyCode == 211 && this.delete.field_146124_l) {
                this.accountsgui.delete();
                return;
            }
            if (keyCode == 28 && !this.search.func_146206_l() && (this.login.field_146124_l || this.loginoffline.field_146124_l)) {
                if (GuiScreen.func_146272_n() && this.loginoffline.field_146124_l) {
                    this.accountsgui.loginOffline();
                } else if (this.login.field_146124_l) {
                    this.accountsgui.login();
                } else {
                    this.accountsgui.loginOffline();
                }
                return;
            }
            if (keyCode == 63) {
                this.reloadSkins();
                return;
            }
            if (typedChar == '+') {
                this.add();
                return;
            }
            if (typedChar == '/' && this.edit.field_146124_l) {
                this.accountsgui.edit();
                return;
            }
            if (typedChar == 'r' || typedChar == 'R') {
                this.reloadSkins();
                return;
            }
        }
        this.search.func_146201_a(typedChar, keyCode);
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.accountsgui.func_148179_a(mouseX, mouseY, mouseButton);
        this.search.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        this.accountsgui.func_148181_b(mouseX, mouseY, state);
        super.func_146286_b(mouseX, mouseY, state);
    }

    public void func_146274_d() throws IOException {
        this.accountsgui.func_178039_p();
        super.func_146274_d();
    }

    private void updateButtons() {
        this.login.field_146124_l = !this.accountsgui.empty() && this.accountsgui.entries.get((int)this.accountsgui.selected()).account.online() && !this.logging;
        this.loginoffline.field_146124_l = !this.accountsgui.empty();
        this.delete.field_146124_l = !this.accountsgui.empty();
        this.edit.field_146124_l = !this.accountsgui.empty() && this.accountsgui.entries.get((int)this.accountsgui.selected()).account.editable();
        this.reloadskins.field_146124_l = !this.accountsgui.empty();
    }

    public class AccountEntry
    implements GuiListExtended.IGuiListEntry {
        public Account account;
        public ResourceLocation modelTexture;
        public ResourceLocation faceTexture;

        public AccountEntry(Account account) {
            this.account = account;
        }

        public void func_192634_a(int i, int x, int y, int w, int h, int mx, int my, boolean hover, float delta) {
            int color = -1;
            if (GuiAccountSelector.this.field_146297_k.func_110432_I().func_111285_a().equals(this.account.alias())) {
                color = 65280;
            }
            GuiAccountSelector.this.func_73731_b(GuiAccountSelector.this.field_146289_q, this.account.alias(), x + 10, y + 1, color);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiAccountSelector.this.field_146297_k.func_110434_K().func_110577_a(this.face(false));
            Gui.func_146110_a((int)x, (int)(y + 1), (float)0.0f, (float)0.0f, (int)8, (int)8, (float)8.0f, (float)8.0f);
            if (GuiAccountSelector.this.accountsgui.selected() == i) {
                boolean movableUp;
                GuiAccountSelector.this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/server_selection.png"));
                boolean movableDown = i + 1 < ((GuiAccountSelector)GuiAccountSelector.this).accountsgui.entries.size();
                boolean bl = movableUp = i > 0;
                if (movableDown) {
                    boolean hoveredDown = mx > x + w - 16 && mx < x + w - 6 && hover;
                    Gui.func_146110_a((int)(x + w - 35), (int)(y - 18), (float)48.0f, (float)(hoveredDown ? 32.0f : 0.0f), (int)32, (int)32, (float)256.0f, (float)256.0f);
                }
                if (movableUp) {
                    boolean hoveredUp = mx > x + w - (movableDown ? 28 : 16) && mx < x + w - (movableDown ? 16 : 6) && hover;
                    Gui.func_146110_a((int)(x + w - (movableDown ? 30 : 19)), (int)(y - 3), (float)96.0f, (float)(hoveredUp ? 32.0f : 0.0f), (int)32, (int)32, (float)256.0f, (float)256.0f);
                }
            }
        }

        public boolean func_148278_a(int i, int mx, int my, int button, int rx, int ry) {
            if (button == 0 && GuiAccountSelector.this.accountsgui.selected() == i) {
                boolean movableUp;
                int w = GuiAccountSelector.this.accountsgui.func_148139_c();
                boolean movableDown = i + 1 < ((GuiAccountSelector)GuiAccountSelector.this).accountsgui.entries.size();
                boolean bl = movableUp = i > 0;
                if (movableDown) {
                    boolean hoveredDown;
                    boolean bl2 = hoveredDown = rx > w - 16 && rx < w - 6;
                    if (hoveredDown) {
                        GuiAccountSelector.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                        GuiAccountSelector.this.accountsgui.swap(i, i + 1);
                    }
                }
                if (movableUp) {
                    boolean hoveredUp;
                    boolean bl3 = rx > w - (movableDown ? 28 : 16) && rx < w - (movableDown ? 16 : 6) ? true : (hoveredUp = false);
                    if (hoveredUp) {
                        GuiAccountSelector.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                        GuiAccountSelector.this.accountsgui.swap(i, i - 1);
                    }
                }
                return true;
            }
            GuiAccountSelector.this.accountsgui.select(i);
            return true;
        }

        public ResourceLocation model(boolean forceReload) {
            if (forceReload) {
                GuiAccountSelector.this.field_146297_k.func_110434_K().func_147645_c(this.modelTexture);
                this.modelTexture = null;
            }
            if (this.modelTexture == null) {
                File model = new File(new File(GuiAccountSelector.this.field_146297_k.field_71412_D, "cachedImages/models"), this.account.alias() + ".png");
                File face = new File(new File(GuiAccountSelector.this.field_146297_k.field_71412_D, "cachedImages/faces"), this.account.alias() + ".png");
                SkinRenderer.loadSkin(GuiAccountSelector.this.field_146297_k, this.account.alias(), this.account.uuid(), model, face, false);
                try {
                    BufferedImage bi = ImageIO.read(model);
                    DynamicTexture nibt = new DynamicTexture(bi);
                    this.modelTexture = GuiAccountSelector.this.field_146297_k.func_110434_K().func_110578_a("iasmodel_" + this.account.alias().hashCode(), nibt);
                }
                catch (Throwable t) {
                    IAS.LOG.warn("Unable to bake skin model: " + this.account.alias(), t);
                    this.modelTexture = new ResourceLocation("iaserror", "skin");
                }
            }
            return this.modelTexture;
        }

        public ResourceLocation face(boolean forceReload) {
            if (forceReload) {
                GuiAccountSelector.this.field_146297_k.func_110434_K().func_147645_c(this.faceTexture);
                this.faceTexture = null;
            }
            if (this.faceTexture == null) {
                File model = new File(new File(GuiAccountSelector.this.field_146297_k.field_71412_D, "cachedImages/models"), this.account.alias() + ".png");
                File face = new File(new File(GuiAccountSelector.this.field_146297_k.field_71412_D, "cachedImages/faces"), this.account.alias() + ".png");
                SkinRenderer.loadSkin(GuiAccountSelector.this.field_146297_k, this.account.alias(), this.account.uuid(), model, face, false);
                try {
                    BufferedImage bi = ImageIO.read(face);
                    DynamicTexture nibt = new DynamicTexture(bi);
                    this.faceTexture = GuiAccountSelector.this.field_146297_k.func_110434_K().func_110578_a("iasface_" + this.account.alias().hashCode(), nibt);
                }
                catch (Throwable t) {
                    IAS.LOG.warn("Unable to bake skin face: " + this.account.alias(), t);
                    this.faceTexture = new ResourceLocation("iaserror", "skin");
                }
            }
            return this.faceTexture;
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }
    }

    public class AccountList
    extends GuiListExtended {
        public ArrayList<AccountEntry> entries;

        public AccountList(Minecraft mc, int width, int height) {
            super(mc, width, height, 32, height - 64, 14);
            this.entries = new ArrayList();
        }

        public GuiListExtended.IGuiListEntry func_148180_b(int index) {
            return this.entries.get(index);
        }

        public int func_148127_b() {
            return this.entries.size();
        }

        public void resize(int width, int height) {
            this.field_148155_a = width;
            this.field_148158_l = height;
            this.field_148153_b = 32;
            this.field_148154_c = height - 64;
        }

        public void updateAccounts() {
            this.entries.clear();
            Config.accounts.stream().filter(acc -> GuiAccountSelector.this.search.func_146179_b().isEmpty() || (Config.caseSensitiveSearch ? acc.alias().startsWith(GuiAccountSelector.this.search.func_146179_b()) : acc.alias().toLowerCase().startsWith(GuiAccountSelector.this.search.func_146179_b().toLowerCase()))).forEach(acc -> this.entries.add(new AccountEntry((Account)acc)));
            this.field_148168_r = this.empty() ? -1 : 0;
        }

        public void login() {
            if (this.empty()) {
                return;
            }
            Account acc = this.entries.get((int)this.field_148168_r).account;
            if (!acc.online()) {
                return;
            }
            GuiAccountSelector.this.logging = true;
            GuiAccountSelector.this.updateButtons();
            acc.use();
            acc.login(this.field_148161_k, t -> {
                GuiAccountSelector.this.logging = false;
                if (t == null) {
                    this.field_148161_k.func_147108_a(GuiAccountSelector.this.prev);
                } else if (t instanceof AuthException) {
                    IAS.LOG.warn("Unable to login", t);
                    GuiAccountSelector.this.error = ((AuthException)t).getText().func_150254_d();
                } else {
                    IAS.LOG.warn("Unable to login", t);
                    GuiAccountSelector.this.error = I18n.func_135052_a((String)"ias.auth.unknown", (Object[])new Object[]{t.toString()});
                }
            });
        }

        public void loginOffline() {
            if (this.empty()) {
                return;
            }
            Account acc = this.entries.get((int)this.field_148168_r).account;
            acc.use();
            this.field_148161_k.field_71449_j = new Session(acc.alias(), UUIDTypeAdapter.fromUUID((UUID)new UUID(0L, 0L)), "0", "legacy");
        }

        public void edit() {
            if (this.empty() || !this.entries.get((int)this.field_148168_r).account.editable()) {
                return;
            }
            this.field_148161_k.func_147108_a((GuiScreen)new AbstractAccountGui(GuiAccountSelector.this, I18n.func_135052_a((String)"ias.editaccount", (Object[])new Object[0]), acc -> Config.accounts.set(this.field_148168_r, (Account)acc)));
        }

        public void delete() {
            if (this.empty()) {
                return;
            }
            Account acc = this.entries.get((int)this.field_148168_r).account;
            this.field_148161_k.func_147108_a((GuiScreen)new GuiYesNo((b, id) -> {
                if (b) {
                    Config.accounts.remove(acc);
                    GuiAccountSelector.this.updateButtons();
                    this.updateAccounts();
                }
                this.field_148161_k.func_147108_a((GuiScreen)GuiAccountSelector.this);
            }, I18n.func_135052_a((String)"ias.delete.title", (Object[])new Object[0]), I18n.func_135052_a((String)"ias.delete.text", (Object[])new Object[]{acc.alias()}), 0));
        }

        public void swap(int first, int second) {
            Account entry = Config.accounts.get(first);
            Config.accounts.set(first, Config.accounts.get(second));
            Config.accounts.set(second, entry);
            Config.save(this.field_148161_k);
            this.updateAccounts();
            this.field_148168_r = second;
        }

        public boolean empty() {
            return this.entries.isEmpty();
        }

        public void select(int id) {
            this.field_148168_r = id;
        }

        public int selected() {
            return this.field_148168_r;
        }

        protected boolean func_148131_a(int slotIndex) {
            return slotIndex == this.field_148168_r;
        }
    }
}

