/*
 * Decompiled with CFR 0.152.
 */
package debarking;

import debarking.blocks.BlockDebarkedLog;
import debarking.blocks.ItemBlockMeta;
import debarking.client.DBStateMapper;
import debarking.compat.ModCompat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="debarkedlogs")
public class DebarkRegistry {
    public static List<Block> toRegister = new ArrayList<Block>();
    public static List<Item> itemBlocks = new ArrayList<Item>();
    private static List<Debarking> debark = new ArrayList<Debarking>();
    public static Block oldDebarked = (Block)new BlockDebarkedLog(Blocks.field_150364_r, new String[]{"axis=y,variant=0", "axis=y,variant=1", "axis=y,variant=2", "axis=y,variant=3"}).func_149663_c("debarked:log_old").setRegistryName(new ResourceLocation("debarkedlogs", "log_old"));
    public static Block newDebarked = (Block)new BlockDebarkedLog(Blocks.field_150363_s, new String[]{"axis=y,variant=0", "axis=y,variant=1"}).func_149663_c("debarked:log_new").setRegistryName(new ResourceLocation("debarkedlogs", "log_new"));

    public static void preInit() {
        DebarkRegistry.registerBlock(oldDebarked, (Item)new ItemBlockMeta(oldDebarked), "oak", "spruce", "birch", "jungle");
        DebarkRegistry.registerBlock(newDebarked, (Item)new ItemBlockMeta(newDebarked), "acacia", "dark_oak");
        ModCompat.preInit();
    }

    public static void init() {
        ModCompat.init();
    }

    public static void postInit() {
        ModCompat.postInit();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> evt) {
        toRegister.forEach(arg_0 -> ((IForgeRegistry)evt.getRegistry()).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> evt) {
        itemBlocks.forEach(arg_0 -> ((IForgeRegistry)evt.getRegistry()).register(arg_0));
    }

    public static Block registerBlock(Block block, Item item, String ... barkNames) {
        toRegister.add(block);
        itemBlocks.add((Item)item.setRegistryName(block.getRegistryName()));
        if (block instanceof BlockDebarkedLog && barkNames != null && barkNames.length > 0) {
            for (int i = 0; i < barkNames.length; ++i) {
                String bark = barkNames[i];
                debark.add(new Debarking((BlockDebarkedLog)block, i, bark));
            }
        }
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setInventoryModel(Block block) {
        DebarkRegistry.setInventoryModel(Item.func_150898_a((Block)block));
    }

    @SideOnly(value=Side.CLIENT)
    public static void setInventoryModel(Item item) {
        if (item instanceof ItemBlock) {
            DebarkRegistry.setInventoryModel((ItemBlock)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setInventoryModel(ItemBlock item) {
        Block block = item.func_179223_d();
        if (block instanceof BlockDebarkedLog) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DBStateMapper(block.getRegistryName().toString()));
            String[] variants = ((BlockDebarkedLog)block).getVariants();
            for (int i = 0; i < variants.length; ++i) {
                if (Objects.equals(variants[i], "")) continue;
                DebarkRegistry.setModelLocation((Item)item, i, variants[i]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void setModelLocation(Item item, int meta, String variantSettings) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), variantSettings));
    }

    public static List<Debarking> getDebarking() {
        return debark;
    }

    public static class Debarking {
        BlockDebarkedLog block;
        int meta;
        String bark;

        public Debarking(BlockDebarkedLog block, int meta, String barkStack) {
            this.block = block;
            this.meta = meta;
            this.bark = barkStack.equals("") ? "oak" : barkStack;
        }

        public boolean matches(IBlockState state) {
            if (this.block.getBaseBlock() == null) {
                return false;
            }
            return state.func_177230_c() == this.block.getBaseBlock() && state.func_177230_c().func_180651_a(state) == this.meta;
        }

        public IBlockState getDebarkState(IBlockState state) {
            return this.block.func_176203_a(state.func_177230_c().func_176201_c(state));
        }

        public String getBarkStack() {
            return this.bark;
        }
    }
}

