/*
 * Decompiled with CFR 0.152.
 */
package debarking.event;

import debarking.DebarkRegistry;
import debarking.compat.ModCompat;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DebarkingEvent {
    @SubscribeEvent
    public void debarkLog(PlayerInteractEvent.RightClickBlock evt) {
        World world = evt.getWorld();
        if (!world.field_72995_K) {
            BlockPos pos = evt.getPos();
            EntityPlayer player = evt.getEntityPlayer();
            IBlockState state = world.func_180495_p(pos);
            ItemStack playerStack = player.func_184586_b(evt.getHand());
            if (playerStack.func_190926_b()) {
                return;
            }
            BlockPos playerPos = pos.func_177972_a(evt.getFace());
            if (!playerStack.func_190926_b() && (playerStack.func_77973_b().getHarvestLevel(playerStack, "axe", player, world.func_180495_p(pos)) >= 0 || playerStack.func_77973_b().getToolClasses(playerStack).contains("axe"))) {
                IBlockState barking = null;
                String bark = "";
                for (DebarkRegistry.Debarking debark : DebarkRegistry.getDebarking()) {
                    if (!debark.matches(state)) continue;
                    barking = debark.getDebarkState(state);
                    bark = debark.getBarkStack();
                    break;
                }
                if (barking != null) {
                    this.ejectStackWithOffset(world, playerPos, ModCompat.getBarkStack(bark).func_77946_l());
                    world.func_175656_a(pos, barking);
                    world.func_184133_a(null, pos, SoundEvents.field_187927_ha, SoundCategory.BLOCKS, 0.5f, 2.5f);
                    playerStack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
        }
    }

    private void ejectStackWithOffset(World world, BlockPos pos, ItemStack stack) {
        if (!stack.func_190926_b()) {
            float xOff = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
            float yOff = world.field_73012_v.nextFloat() * 0.2f + 0.1f;
            float zOff = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
            this.ejectStack(world, (float)pos.func_177958_n() + xOff, (float)pos.func_177956_o() + yOff, (float)pos.func_177952_p() + zOff, stack, 10);
        }
    }

    private void ejectStack(World world, double x, double y, double z, ItemStack stack, int pickupDelay) {
        if (!world.field_72995_K) {
            EntityItem item = new EntityItem(world, x, y, z, stack);
            float velocity = 0.05f;
            item.field_70159_w = (float)world.field_73012_v.nextGaussian() * velocity;
            item.field_70181_x = (float)world.field_73012_v.nextGaussian() * velocity + 0.2f;
            item.field_70179_y = (float)world.field_73012_v.nextGaussian() * velocity;
            item.func_174867_a(pickupDelay);
            world.func_72838_d((Entity)item);
        }
    }
}

