/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.gadgets.tileentity.TileWoodenHopper;

public class BlockWoodenHopper
extends BlockContainer {
    private static final EnumMap<EnumFacing, List<AxisAlignedBB>> bounds;
    protected static final AxisAlignedBB BASE_AABB;
    protected static final AxisAlignedBB SOUTH_AABB;
    protected static final AxisAlignedBB NORTH_AABB;
    protected static final AxisAlignedBB WEST_AABB;
    protected static final AxisAlignedBB EAST_AABB;

    public BlockWoodenHopper() {
        super(Material.field_151575_d, MapColor.field_151665_m);
        this.func_149711_c(3.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockHopper.field_176430_a, (Comparable)EnumFacing.DOWN));
    }

    private static AxisAlignedBB makeAABB(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return new AxisAlignedBB((double)((float)fromX / 16.0f), (double)((float)fromY / 16.0f), (double)((float)fromZ / 16.0f), (double)((float)toX / 16.0f), (double)((float)toY / 16.0f), (double)((float)toZ / 16.0f));
    }

    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return bounds.get(blockState.func_177229_b((IProperty)BlockHopper.field_176430_a)).stream().map(bb -> this.func_185503_a(pos, start, end, (AxisAlignedBB)bb)).anyMatch(Objects::nonNull) ? super.func_180636_a(blockState, worldIn, pos, start, end) : null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileWoodenHopper();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = facing.func_176734_d();
        if (enumfacing == EnumFacing.UP) {
            enumfacing = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)BlockHopper.field_176430_a, (Comparable)enumfacing);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = BlockWoodenHopper.getFacing(meta);
        if (facing == EnumFacing.UP) {
            facing = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)BlockHopper.field_176430_a, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)BlockHopper.field_176430_a)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHopper.field_176430_a});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        BlockWoodenHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityHopper) {
            ((TileEntityHopper)tileentity).func_190575_a(stack.func_82833_r());
        }
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityHopper) {
            playerIn.func_71007_a((IInventory)((TileEntityHopper)tileentity));
            playerIn.func_71029_a(StatList.field_188084_R);
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityHopper) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityHopper)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public static EnumFacing getFacing(int meta) {
        return EnumFacing.func_82600_a((int)(meta & 7));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockHopper.field_176430_a, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockHopper.field_176430_a)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockHopper.field_176430_a)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.BOWL : BlockFaceShape.UNDEFINED;
    }

    private static /* synthetic */ List lambda$static$2(List commonBounds, EnumFacing a) {
        return new ArrayList(commonBounds);
    }

    static {
        ImmutableList commonBounds = ImmutableList.of((Object)BlockWoodenHopper.makeAABB(0, 10, 0, 16, 16, 16), (Object)BlockWoodenHopper.makeAABB(4, 4, 4, 12, 10, 12));
        bounds = Stream.of(EnumFacing.values()).filter(t -> t != EnumFacing.UP).collect(Collectors.toMap(a -> a, arg_0 -> BlockWoodenHopper.lambda$static$2((List)commonBounds, arg_0), (u, v) -> {
            throw new IllegalStateException();
        }, () -> new EnumMap(EnumFacing.class)));
        bounds.get(EnumFacing.DOWN).add(BlockWoodenHopper.makeAABB(6, 0, 6, 10, 4, 10));
        bounds.get(EnumFacing.NORTH).add(BlockWoodenHopper.makeAABB(6, 4, 0, 10, 8, 4));
        bounds.get(EnumFacing.SOUTH).add(BlockWoodenHopper.makeAABB(6, 4, 12, 10, 8, 16));
        bounds.get(EnumFacing.WEST).add(BlockWoodenHopper.makeAABB(0, 4, 6, 4, 8, 10));
        bounds.get(EnumFacing.EAST).add(BlockWoodenHopper.makeAABB(12, 4, 6, 16, 8, 10));
        BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
        SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
        NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
        WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
        EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    }
}

