/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.Locale;
import java.util.Random;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockEnderInhibitorOff;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEnderInhibitorOn
extends Block {
    public static final EnumProperty<EnumGemDirection> TYPE = EnumProperty.m_61587_((String)"type", EnumGemDirection.class);
    public static final VoxelShape DOWN_NORTH_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0);
    public static final VoxelShape DOWN_SOUTH_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0);
    public static final VoxelShape DOWN_WEST_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)3.0, (double)14.0);
    public static final VoxelShape DOWN_EAST_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)3.0, (double)14.0);
    public static final VoxelShape UP_NORTH_AABB = Block.m_49796_((double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0);
    public static final VoxelShape UP_SOUTH_AABB = Block.m_49796_((double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0);
    public static final VoxelShape UP_WEST_AABB = Block.m_49796_((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0);
    public static final VoxelShape UP_EAST_AABB = Block.m_49796_((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0);
    public static final VoxelShape NORTH_AABB = Block.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)13.0, (double)3.0);
    public static final VoxelShape SOUTH_AABB = Block.m_49796_((double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0, (double)16.0);
    public static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0);
    public static final VoxelShape EAST_AABB = Block.m_49796_((double)13.0, (double)3.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0);

    public BlockEnderInhibitorOn(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)EnumGemDirection.DOWN_NORTH)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level world, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.m_123341_() + rand.nextFloat();
            double d1 = (float)pos.m_123342_() + rand.nextFloat();
            double d2 = (float)pos.m_123343_() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (world.m_8055_(pos.m_142125_()).m_60734_() != this && world.m_8055_(pos.m_142126_()).m_60734_() != this) {
                d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((EnumGemDirection)((Object)state.m_61143_(TYPE))) {
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case UP_NORTH: {
                return UP_NORTH_AABB;
            }
            case UP_EAST: {
                return UP_EAST_AABB;
            }
            case UP_SOUTH: {
                return UP_SOUTH_AABB;
            }
            case UP_WEST: {
                return UP_WEST_AABB;
            }
            case DOWN_NORTH: {
                return DOWN_NORTH_AABB;
            }
            case DOWN_EAST: {
                return DOWN_EAST_AABB;
            }
            case DOWN_SOUTH: {
                return DOWN_SOUTH_AABB;
            }
            case DOWN_WEST: {
                return DOWN_WEST_AABB;
            }
        }
        return DOWN_NORTH_AABB;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        switch ((EnumGemDirection)((Object)state.m_61143_(TYPE))) {
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case UP_NORTH: {
                return UP_NORTH_AABB;
            }
            case UP_EAST: {
                return UP_EAST_AABB;
            }
            case UP_SOUTH: {
                return UP_SOUTH_AABB;
            }
            case UP_WEST: {
                return UP_WEST_AABB;
            }
            case DOWN_NORTH: {
                return DOWN_NORTH_AABB;
            }
            case DOWN_EAST: {
                return DOWN_EAST_AABB;
            }
            case DOWN_SOUTH: {
                return DOWN_SOUTH_AABB;
            }
            case DOWN_WEST: {
                return DOWN_WEST_AABB;
            }
        }
        return DOWN_NORTH_AABB;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        EnumGemDirection newFacing = (EnumGemDirection)((Object)state.m_61143_(TYPE));
        boolean flag = false;
        if ((newFacing == EnumGemDirection.UP_NORTH || newFacing == EnumGemDirection.UP_EAST || newFacing == EnumGemDirection.UP_SOUTH || newFacing == EnumGemDirection.UP_WEST) && world.m_8055_(pos.m_7494_()).m_60659_((BlockGetter)world, pos.m_7494_(), Direction.DOWN, SupportType.RIGID)) {
            flag = true;
        }
        if ((newFacing == EnumGemDirection.DOWN_NORTH || newFacing == EnumGemDirection.DOWN_EAST || newFacing == EnumGemDirection.DOWN_SOUTH || newFacing == EnumGemDirection.DOWN_WEST) && world.m_8055_(pos.m_7495_()).m_60659_((BlockGetter)world, pos.m_7495_(), Direction.UP, SupportType.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.NORTH && world.m_8055_(pos.m_142300_(Direction.NORTH)).m_60659_((BlockGetter)world, pos.m_142300_(Direction.NORTH), Direction.NORTH, SupportType.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.SOUTH && world.m_8055_(pos.m_142300_(Direction.SOUTH)).m_60659_((BlockGetter)world, pos.m_142300_(Direction.SOUTH), Direction.SOUTH, SupportType.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.WEST && world.m_8055_(pos.m_142300_(Direction.WEST)).m_60659_((BlockGetter)world, pos.m_142300_(Direction.WEST), Direction.WEST, SupportType.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.EAST && world.m_8055_(pos.m_142300_(Direction.EAST)).m_60659_((BlockGetter)world, pos.m_142300_(Direction.EAST), Direction.EAST, SupportType.RIGID)) {
            flag = true;
        }
        if (!flag) {
            BlockEnderInhibitorOn.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModBlocks.ENDER_INHIBITOR_OFF.getItem(), 1));
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            BlockState activeState = (BlockState)ModBlocks.ENDER_INHIBITOR_OFF.getBlock().m_49966_().m_61124_((Property)BlockEnderInhibitorOff.TYPE, (Comparable)((Object)((EnumGemDirection)((Object)state.m_61143_(TYPE)))));
            world.m_7731_(pos, activeState, 3);
            world.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.6f);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!BlockEnderInhibitorOn.m_49863_((LevelReader)world, (BlockPos)pos.m_142300_(enumfacing.m_122424_()), (Direction)enumfacing)) continue;
            return true;
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_();
        Direction direction = context.m_43723_().m_6350_();
        EnumGemDirection newFacing = EnumGemDirection.DOWN_NORTH;
        if (facing == Direction.UP) {
            switch (direction) {
                case SOUTH: {
                    newFacing = EnumGemDirection.DOWN_SOUTH;
                    break;
                }
                case EAST: {
                    newFacing = EnumGemDirection.DOWN_WEST;
                    break;
                }
                case NORTH: {
                    newFacing = EnumGemDirection.DOWN_NORTH;
                    break;
                }
                case WEST: {
                    newFacing = EnumGemDirection.DOWN_EAST;
                }
            }
        } else if (facing == Direction.DOWN) {
            switch (direction) {
                case SOUTH: {
                    newFacing = EnumGemDirection.UP_SOUTH;
                    break;
                }
                case EAST: {
                    newFacing = EnumGemDirection.UP_WEST;
                    break;
                }
                case NORTH: {
                    newFacing = EnumGemDirection.UP_NORTH;
                    break;
                }
                case WEST: {
                    newFacing = EnumGemDirection.UP_EAST;
                }
            }
        } else {
            switch (facing) {
                case SOUTH: {
                    newFacing = EnumGemDirection.NORTH;
                    break;
                }
                case EAST: {
                    newFacing = EnumGemDirection.WEST;
                    break;
                }
                case NORTH: {
                    newFacing = EnumGemDirection.SOUTH;
                    break;
                }
                case WEST: {
                    newFacing = EnumGemDirection.EAST;
                }
            }
        }
        return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)newFacing));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE});
    }

    public static enum EnumGemDirection implements StringRepresentable
    {
        DOWN_NORTH,
        DOWN_SOUTH,
        DOWN_WEST,
        DOWN_EAST,
        UP_NORTH,
        UP_SOUTH,
        UP_WEST,
        UP_EAST,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

