/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEntityConveyor
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape CONVEYOR_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public BlockEntityConveyor(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CONVEYOR_AABB;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.m_6144_()) {
            return;
        }
        if (entity instanceof Mob) {
            ((Mob)entity).m_21530_();
        } else if (entity instanceof ItemEntity) {
            ((ItemEntity)entity).m_32064_();
        }
        double speed = this.speed();
        int meta = ((Direction)state.m_61143_((Property)FACING)).m_122411_() - 2;
        int[] factorX = new int[]{0, 0, -1, 1};
        int[] factorZ = new int[]{-1, 1, 0, 0};
        if (entity.m_20186_() > (double)pos.m_123342_() + 0.5) {
            Vec3 vec3d = entity.m_20184_();
            if (factorX[meta] == 0 && Math.abs((double)pos.m_123341_() + 0.5 - entity.m_20185_()) < 0.5 && Math.abs((double)pos.m_123341_() + 0.5 - entity.m_20185_()) > 0.1) {
                entity.m_20334_(vec3d.f_82479_ + Math.signum((double)pos.m_123341_() + 0.5 - entity.m_20185_()) * Math.min(speed, Math.abs((double)pos.m_123341_() + 0.5 - entity.m_20185_())) / 1.2, vec3d.f_82480_, vec3d.f_82481_);
            }
            if (factorZ[meta] == 0 && Math.abs((double)pos.m_123343_() + 0.5 - entity.m_20189_()) < 0.5 && Math.abs((double)pos.m_123343_() + 0.5 - entity.m_20189_()) > 0.1) {
                entity.m_20334_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_ + Math.signum((double)pos.m_123343_() + 0.5 - entity.m_20189_()) * Math.min(speed, Math.abs((double)pos.m_123343_() + 0.5 - entity.m_20189_())) / 1.2);
            }
            entity.m_20334_(vec3d.f_82479_ + (double)factorX[meta] * speed, vec3d.f_82480_, vec3d.f_82481_ + (double)factorZ[meta] * speed);
        }
    }

    protected double speed() {
        return 0.2;
    }
}

