/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockSaw;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.models.ModelSawBase;
import mob_grinding_utils.models.ModelSawBlade;
import mob_grinding_utils.tile.TileEntitySaw;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntitySawRenderer
implements BlockEntityRenderer<TileEntitySaw> {
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/saw_base.png");
    private static final ResourceLocation BLADE_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/saw_blade.png");
    private final ModelSawBase saw_base;
    private final ModelSawBlade saw_blade;

    public TileEntitySawRenderer(BlockEntityRendererProvider.Context context) {
        this.saw_base = new ModelSawBase(context.m_173582_(ModelLayers.SAW_BASE));
        this.saw_blade = new ModelSawBlade(context.m_173582_(ModelLayers.SAW_BLADE));
    }

    public void render(TileEntitySaw tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.m_58898_()) {
            return;
        }
        BlockState state = tile.m_58904_().m_8055_(tile.m_58899_());
        if (state == null || state.m_60734_() != ModBlocks.SAW.getBlock()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockSaw.f_52588_);
        VertexConsumer ivertexbuilder = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)BASE_TEXTURE));
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        switch (facing) {
            case UP: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
                break;
            }
            case DOWN: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                break;
            }
            case NORTH: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case SOUTH: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                break;
            }
            case WEST: {
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                break;
            }
            case EAST: {
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
            }
        }
        matrixStack.m_85837_(0.0, -1.0, 0.0);
        this.saw_base.m_7695_(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85836_();
        float ticks = (float)tile.animationTicks + (float)(tile.animationTicks - tile.prevAnimationTicks) * partialTicks;
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(ticks));
        this.saw_base.renderAxle(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
        this.saw_base.renderMace(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(165.0f));
        this.saw_base.renderMace(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(285.0f));
        this.saw_base.renderMace(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)0.2f, (double)-0.16f);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(8.0f));
        this.saw_blade.m_7695_(matrixStack, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)BLADE_TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, (double)0.16f);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-8.0f));
        this.saw_blade.m_7695_(matrixStack, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)BLADE_TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)-0.2f, (double)-0.16f);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(8.0f));
        this.saw_blade.m_7695_(matrixStack, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)BLADE_TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }
}

