/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.events;

import java.util.Optional;
import javax.annotation.Nonnull;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ModSounds;
import mob_grinding_utils.network.MessageChickenSync;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class ChickenFuseEvent {
    @Nonnull
    public static ItemStack getSpawnEgg(@Nonnull EntityType<?> entityType) {
        SpawnEggItem egg = ForgeSpawnEggItem.fromEntityType(entityType);
        return egg != null ? new ItemStack((ItemLike)egg) : ItemStack.f_41583_;
    }

    @SubscribeEvent
    public void startChickenFuse(LivingEvent event) {
        LivingEntity entity = (LivingEntity)event.getEntity();
        if (entity instanceof Chicken) {
            CompoundTag nbt;
            Level world = entity.m_20193_();
            if (!world.f_46443_ && (nbt = entity.getPersistentData()).m_128441_("shouldExplode")) {
                int startTime = event.getEntity().getPersistentData().m_128451_("countDown");
                if (startTime <= 19) {
                    nbt.m_128405_("countDown", nbt.m_128451_("countDown") + 1);
                    MobGrindingUtils.NETWORK_WRAPPER.send(PacketDistributor.ALL.noArg(), (Object)new MessageChickenSync(entity, nbt));
                }
                if (startTime >= 20) {
                    Optional entityMob = EntityType.m_20632_((String)event.getEntity().getPersistentData().m_128461_("mguMobName"));
                    entityMob.ifPresent(mob -> {
                        ItemStack eggItem = ChickenFuseEvent.getSpawnEgg(mob);
                        if (eggItem != ItemStack.f_41583_) {
                            entity.m_5552_(eggItem, 0.0f);
                        }
                    });
                    if (nbt.m_128441_("nutritious") && nbt.m_128471_("nutritious")) {
                        entity.m_5552_(new ItemStack((ItemLike)ModItems.GOLDEN_EGG.get()), 0.0f);
                    }
                    if (nbt.m_128441_("cursed") && nbt.m_128471_("cursed")) {
                        entity.m_5552_(new ItemStack((ItemLike)ModItems.ROTTEN_EGG.get()), 0.0f);
                        entity.m_5496_((SoundEvent)ModSounds.SPOOPY_CHANGE.get(), 1.0f, 1.0f);
                    } else {
                        entity.m_5496_(SoundEvents.f_11751_, 1.0f, 1.0f);
                        entity.m_5496_((SoundEvent)ModSounds.CHICKEN_RISE.get(), 0.5f, 1.0f);
                    }
                    for (int k = 0; k < 4; ++k) {
                        ItemStack stack = new ItemStack((ItemLike)Items.f_42402_);
                        ItemEntity feather = new ItemEntity(world, entity.m_20185_() + (double)(world.f_46441_.nextFloat() * entity.m_20205_() * 2.0f) - (double)entity.m_20205_(), entity.m_20186_() + (double)(world.f_46441_.nextFloat() * entity.m_20206_()), entity.m_20189_() + (double)(world.f_46441_.nextFloat() * entity.m_20205_() * 2.0f) - (double)entity.m_20205_(), stack);
                        world.m_7967_((Entity)feather);
                    }
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }
}

