/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mrcrayfish.guns.Config;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BulletHoleParticle
extends TextureSheetParticle {
    private final Direction direction;
    private final BlockPos pos;
    private int uOffset;
    private int vOffset;
    private float textureDensity;

    public BulletHoleParticle(ClientLevel world, double x, double y, double z, Direction direction, BlockPos pos) {
        super(world, x, y, z);
        this.m_108337_(this.getSprite(pos));
        this.direction = direction;
        this.pos = pos;
        this.f_107225_ = (int)((float)((Integer)Config.CLIENT.particle.bulletHoleLifeMin.get()).intValue() + world.f_46441_.nextFloat() * (float)((Integer)Config.CLIENT.particle.bulletHoleLifeMax.get() - (Integer)Config.CLIENT.particle.bulletHoleLifeMin.get()));
        this.f_107219_ = false;
        this.f_107226_ = 0.0f;
        this.f_107663_ = 0.05f;
        BlockState state = world.m_8055_(pos);
        if (world.m_8055_(pos).m_60795_()) {
            this.m_107274_();
        }
        int color = this.getBlockColor(state, (Level)world, pos, direction);
        this.f_107227_ = (float)(color >> 16 & 0xFF) / 255.0f / 3.0f;
        this.f_107228_ = (float)(color >> 8 & 0xFF) / 255.0f / 3.0f;
        this.f_107229_ = (float)(color & 0xFF) / 255.0f / 3.0f;
        this.f_107230_ = 0.9f;
    }

    private int getBlockColor(BlockState state, Level world, BlockPos pos, Direction direction) {
        if (state.m_60734_() == Blocks.f_50440_) {
            return Integer.MAX_VALUE;
        }
        return Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)world, pos, 0);
    }

    protected void m_108337_(TextureAtlasSprite sprite) {
        super.m_108337_(sprite);
        this.uOffset = this.f_107223_.nextInt(16);
        this.vOffset = this.f_107223_.nextInt(16);
        this.textureDensity = (sprite.m_118410_() - sprite.m_118409_()) / 16.0f;
    }

    private TextureAtlasSprite getSprite(BlockPos pos) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel world = minecraft.f_91073_;
        if (world != null) {
            BlockState state = world.m_8055_(pos);
            return Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state);
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
    }

    protected float m_5970_() {
        return this.f_108321_.m_118409_() + (float)this.uOffset * this.textureDensity;
    }

    protected float m_5951_() {
        return this.f_108321_.m_118411_() + (float)this.vOffset * this.textureDensity;
    }

    protected float m_5952_() {
        return this.m_5970_() + this.textureDensity;
    }

    protected float m_5950_() {
        return this.m_5951_() + this.textureDensity;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107208_.m_8055_(this.pos).m_60795_()) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 view = renderInfo.m_90583_();
        float particleX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - view.m_7096_());
        float particleY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - view.m_7098_());
        float particleZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - view.m_7094_());
        Quaternion quaternion = this.direction.m_122406_();
        Vector3f[] points = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
        float scale = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = points[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(scale);
            vector3f.m_122272_(particleX, particleY, particleZ);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        float fade = (Double)Config.CLIENT.particle.bulletHoleFadeThreshold.get() >= 1.0 ? 1.0f : 1.0f - Math.max((float)this.f_107224_ - (float)this.f_107225_ * ((Double)Config.CLIENT.particle.bulletHoleFadeThreshold.get()).floatValue(), 0.0f) / ((float)this.f_107225_ - (float)this.f_107225_ * ((Double)Config.CLIENT.particle.bulletHoleFadeThreshold.get()).floatValue());
        buffer.m_5483_((double)points[0].m_122239_(), (double)points[0].m_122260_(), (double)points[0].m_122269_()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * fade).m_85969_(j).m_5752_();
        buffer.m_5483_((double)points[1].m_122239_(), (double)points[1].m_122260_(), (double)points[1].m_122269_()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * fade).m_85969_(j).m_5752_();
        buffer.m_5483_((double)points[2].m_122239_(), (double)points[2].m_122260_(), (double)points[2].m_122269_()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * fade).m_85969_(j).m_5752_();
        buffer.m_5483_((double)points[3].m_122239_(), (double)points[3].m_122260_(), (double)points[3].m_122269_()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * fade).m_85969_(j).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }
}

