/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.common.AmmoContext;
import com.mrcrayfish.guns.common.DelayedTask;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.S2CMessageGunSound;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="cgm")
public class ReloadTracker {
    private static final Map<Player, ReloadTracker> RELOAD_TRACKER_MAP = new WeakHashMap<Player, ReloadTracker>();
    private final int startTick;
    private final int slot;
    private final ItemStack stack;
    private final Gun gun;

    private ReloadTracker(Player player) {
        this.startTick = player.f_19797_;
        this.slot = player.m_150109_().f_35977_;
        this.stack = player.m_150109_().m_36056_();
        this.gun = ((GunItem)this.stack.m_41720_()).getModifiedGun(this.stack);
    }

    private boolean isSameWeapon(Player player) {
        return !this.stack.m_41619_() && player.m_150109_().f_35977_ == this.slot && player.m_150109_().m_36056_() == this.stack;
    }

    private boolean isWeaponFull() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128451_("AmmoCount") >= GunEnchantmentHelper.getAmmoCapacity(this.stack, this.gun);
    }

    private boolean hasNoAmmo(Player player) {
        return Gun.findAmmo(player, this.gun.getProjectile().getItem()).stack().m_41619_();
    }

    private boolean canReload(Player player) {
        int deltaTicks = player.f_19797_ - this.startTick;
        int interval = GunEnchantmentHelper.getReloadInterval(this.stack);
        return deltaTicks > 0 && deltaTicks % interval == 0;
    }

    private void increaseAmmo(Player player) {
        ResourceLocation reloadSound;
        AmmoContext context = Gun.findAmmo(player, this.gun.getProjectile().getItem());
        ItemStack ammo = context.stack();
        if (!ammo.m_41619_()) {
            int amount = Math.min(ammo.m_41613_(), this.gun.getGeneral().getReloadAmount());
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null) {
                int maxAmmo = GunEnchantmentHelper.getAmmoCapacity(this.stack, this.gun);
                amount = Math.min(amount, maxAmmo - tag.m_128451_("AmmoCount"));
                tag.m_128405_("AmmoCount", tag.m_128451_("AmmoCount") + amount);
            }
            ammo.m_41774_(amount);
            Container container = context.container();
            if (container != null) {
                container.m_6596_();
            }
        }
        if ((reloadSound = this.gun.getSounds().getReload()) != null) {
            double radius = (Double)Config.SERVER.reloadMaxDistance.get();
            S2CMessageGunSound message = new S2CMessageGunSound(reloadSound, SoundSource.PLAYERS, (float)player.m_20185_(), (float)player.m_20186_() + 1.0f, (float)player.m_20189_(), 1.0f, 1.0f, player.m_142049_(), false, true);
            PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), radius, player.f_19853_.m_46472_())), (Object)message);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.f_19853_.f_46443_) {
            Player player = event.player;
            if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                ReloadTracker tracker;
                if (!RELOAD_TRACKER_MAP.containsKey(player)) {
                    if (!(player.m_150109_().m_36056_().m_41720_() instanceof GunItem)) {
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                        return;
                    }
                    RELOAD_TRACKER_MAP.put(player, new ReloadTracker(player));
                }
                if (!(tracker = RELOAD_TRACKER_MAP.get(player)).isSameWeapon(player) || tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                    RELOAD_TRACKER_MAP.remove(player);
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    return;
                }
                if (tracker.canReload(player)) {
                    tracker.increaseAmmo(player);
                    if (tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                        RELOAD_TRACKER_MAP.remove(player);
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                        Player finalPlayer = player;
                        Gun gun = tracker.gun;
                        DelayedTask.runAfter(4, () -> {
                            ResourceLocation cockSound = gun.getSounds().getCock();
                            if (cockSound != null && finalPlayer.m_6084_()) {
                                double radius = (Double)Config.SERVER.reloadMaxDistance.get();
                                S2CMessageGunSound messageSound = new S2CMessageGunSound(cockSound, SoundSource.PLAYERS, (float)finalPlayer.m_20185_(), (float)(finalPlayer.m_20186_() + 1.0), (float)finalPlayer.m_20189_(), 1.0f, 1.0f, finalPlayer.m_142049_(), false, true);
                                PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(finalPlayer.m_20185_(), finalPlayer.m_20186_() + 1.0, finalPlayer.m_20189_(), radius, finalPlayer.f_19853_.m_46472_())), (Object)messageSound);
                            }
                        });
                    }
                }
            } else if (RELOAD_TRACKER_MAP.containsKey(player)) {
                RELOAD_TRACKER_MAP.remove(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getPlayer().m_20194_();
        if (server != null) {
            server.execute(() -> RELOAD_TRACKER_MAP.remove(event.getPlayer()));
        }
    }
}

